/**
 * @file mem.h
 * @brief メモリ関係
 * @author BananaJinn
 * @version $Id: mem.h,v 1.2 2010/11/05 17:24:03 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2007 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __MEM_H__
#define __MEM_H__

#if defined(DEBUGMEM)
extern void *MemNewF(const char *fname, long line,
					 size_t size);
extern void *MemResizeF(const char *fname, long line,
						void *ptr, size_t new_size);
extern void *MemFreeF(const char *fname, long line,
					  void *ptr);
# define MemNew(s) MemNewF(__FILE__, __LINE__, s)
# define MemResize(p,s) MemResizeF(__FILE__, __LINE__, p, s)
# define MemFree(p) MemFreeF(__FILE__, __LINE__, p)
#else /* DEBUGMEM */
# define MemNew(s) malloc(s)
# define MemResize(p,s) realloc(p,s)
# define MemFree(p) free(p)
#endif /* DEBUGMEM */

extern void MemDebugStart();
extern void MemDebugEnd();
extern void MemDumpLeaks();

#endif /* !__MEM_H__ */
