/**
 * @file image.h
 * @brief イメージファイル
 * @author BananaJinn
 * @version $Id: image.h,v 1.5 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __IMAGE_H__
#define __IMAGE_H__

#include <stdio.h>
#include "aspi.h"

typedef struct {
	FILE *fp;
	char *filename;
	int fileindex;
	DWORD bytecount;
} IMAGEFILE;

extern int InitializeImage(IMAGEFILE *image);
extern void FreeImage(IMAGEFILE *image);
extern int OpenImage(IMAGEFILE *image, const char *filename, BOOL reader);
extern int ReadImageFile(IMAGEFILE *image, void *buf, DWORD size, BOOL split);
extern int WriteImageFile(IMAGEFILE *image, void *buf, DWORD size, BOOL split);
extern void RemoveImageFile(const char *basefilename);

#endif /* !__IMAGE_H__ */
