/**
 * @file ebstring.h
 * @brief 文字列操作
 * @author BananaJinn
 * @version $Id: ebstring.h,v 1.4 2010/11/05 17:24:03 bananajinn Exp $
 * 円盤複写屋 - EnbanFukusyaYa
 * Copyright (C) 2005-2006 Kagetani Hideto
 */
#ifndef __EBSTRING_H__
#define __EBSTRING_H__

#if defined(WIN32)
# define PATH_SEPARATOR '\\'
#else
# define PATH_SEPARATOR '/'
#endif

extern char *EbStringNew(const char *string);
extern char *EbStringNewWithFormat(const char *format, ...);
extern char *EbStringAppend(char *ebstring, const char *append_string);
extern char *EbStringAppendWithFormat(char *ebstring, const char *format, ...);
extern char *EbStringAppendPath(char *ebstring, const char *path);
extern char *EbStringFree(char *ebstring);
extern char *EbStringGetString(const char *string, int len, char trim);

#endif /* !__EBSTRING_H__ */
