/**
 * @file discinfo.h
 * @brief ディスク情報取得関連
 * @author BananaJinn
 * @version $Id: discinfo.h,v 1.4 2010/11/05 17:24:03 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __DISCINFO_H__
#define __DISCINFO_H__

typedef struct {
  struct _TRACKINFO trackinfo;
  BYTE mode2;			/* MODE2なら1、それ以外は0 */
  BYTE isrc[12+1];
  BOOL tao;			/* TAOで記録されているかどうか */
  WORD pause_len;		/* Audio Pause Length */
} CPTRACKINFO;

#define IS_TRACKMODE_DATA(m)	(((m) & 0x0c)==4)

typedef struct {
  BYTE disc_type;
  BYTE disc_stat;
  BYTE last_sess_stat;
  BYTE media_catalog_number[13+1];
  DWORD last_addr;
  WORD sessions;
  WORD tracks;
  BYTE *cdtext;
  DWORD cdtext_size;
  DWORD outside_offset;		/* ISO外側記録のオフセット */
  CPTRACKINFO *trackinfo;	/* <= 必ず最後 */
} CPDISCINFO;


extern int SetDiscInformation(CMDDRIVE *drive, CPDISCINFO *discinfo);
extern int GetDiscInformation(CMDDRIVE *drive, CPDISCINFO *discinfo);



#endif /* !__DISCINFO_H__ */
