/**
 * @file cmd.h
 * @brief コマンド発行関連
 * @author BananaJinn
 * @version $Id: cmd.h,v 1.16 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __CMD_H__
#define __CMD_H__

#include "aspi.h"
#include "netaccess.h"
#include "image.h"
#include "struct.h"
#include "drive.h"


// ASPI Command
#define CMD_TEST_UNIT_READY		0x00
#define CMD_REZERO_UNIT			0x01
#define CMD_REQUEST_SENSE		0x03
#define CMD_FORMAT_UNIT			0x04
#define CMD_READ6				0x08
#define CMD_SEEK6				0x0b
#define CMD_INQUIRY				0x12
#define CMD_MODE_SELECT6		0x15
#define CMD_RESERVE				0x16
#define CMD_RELEASE				0x17
#define CMD_MODE_SENSE6			0x1a
#define CMD_START_STOP			0x1b
#define CMD_RECIEVE_DIAG		0x1c
#define CMD_SEND_DIAG			0x1d
#define CMD_PREVENT_ALLOW		0x1e
#define CMD_READ_CAPACITY		0x25
#define CMD_READ10				0x28
#define CMD_SEEK10				0x2b
#define CMD_VERIFY				0x2f
#define CMD_PRE_FETCH			0x34
#define CMD_WRITE_BUFFER		0x3b
#define CMD_READ_BUFFER			0x3c
#define CMD_READ_SUBCHANNEL		0x42
#define CMD_READ_TOC			0x43
#define CMD_READ_HEADER			0x44
#define CMD_PLAY_AUDIO10		0x45
#define CMD_PLAY_AUDIO_MSF		0x47
#define CMD_PLAY_TRACK_INDEX	0x48
#define CMD_PLAY_RELATIVE10		0x49
#define CMD_PAUSE				0x4b
#define CMD_MODE_SELECT10		0x55
#define CMD_MODE_SENSE10		0x5a
#define CMD_PLAY_AUDIO12		0xa5
#define CMD_READ12				0xa8
#define CMD_PLAY_RELATIVE12		0xa9
#define CMD_SET_CD_SPEED		0xbb
#define CMD_MECHANISM_STATUS	0xbd
#define CMD_READ_CD				0xbe
#define CMD_READ_CD_DA			0xd4
#define CMD_READ_P_W_SUBCODE	0xd6
#define CMD_WRITE10				0x2a
#define CMD_WRITE12				0xaa
#define CMD_WRITE_AND_VERIFY	0x2e
#define CMD_SYNCHRONIZE_CACHE	0x35
#define CMD_READ_DISC_INFO		0x51
#define CMD_READ_TRACK_INFO		0x52
#define CMD_RESERVE_TRACK		0x53
#define CMD_REPAIR_TRACK		0x58
#define CMD_READ_MASTER_CUE		0x59
#define CMD_CLOSE_TRACK_SESSION	0x5b
#define CMD_READ_BUFFER_CAPACITY	0x5c
#define CMD_SEND_CUE_SHEET		0x5d
#define CMD_SEND_OPC_INFOMATION	0x54
#define CMD_BLANK				0xa1
#define CMD_READ_CD_MSF			0xb9
#define CMD_AUDIO_SCAN			0xba
#define CMD_GET_CONFIGURATION	0x46
#define CMD_GET_PERFORMANCE		0x4C
#define CMD_READ_DVD_STRUCTURE	0xad
#define CMD_READ_FORMAT_CAPACITIES	0x23
#define CMD_REPORT_KEY			0xa4
#define CMD_SEND_EVENT			0xa2
#define CMD_SEND_KEY			0xa3
#define CMD_SET_READ_AHEAD		0xa7
#define CMD_SET_STREAMING		0xb6
#define CMD_SEND_DVD_STRUCTURE	0xbf


#ifdef __cplusplus
extern "C" {
#endif

extern WORD Get2bytes(BYTE *buf);
extern DWORD Get3bytes(BYTE *buf);
extern DWORD Get4bytes(BYTE *buf);
extern void Set2bytes(BYTE *buf, WORD value);
extern void Set3bytes(BYTE *buf, DWORD value);
extern void Set4bytes(BYTE *buf, DWORD value);
extern WORD Get2bytesLE(BYTE *buf);
extern DWORD Get3bytesLE(BYTE *buf);
extern DWORD Get4bytesLE(BYTE *buf);
extern void Set2bytesLE(BYTE *buf, WORD value);
extern void Set3bytesLE(BYTE *buf, DWORD value);
extern void Set4bytesLE(BYTE *buf, DWORD value);

extern DWORD MSF2LBA(BYTE min, BYTE sec, BYTE frame, BOOL force_positive);
extern BOOL LBA2MSF(DWORD lba, BYTE *min, BYTE *sec, BYTE *frame);

extern int SendTestUnitReady(CMDDRIVE *drive);
extern int SendStartStop(CMDDRIVE *drive, BYTE immed, BYTE load_eject, BYTE start_or_load);
extern int SendPreventAllow(CMDDRIVE *drive, BYTE prevent);
extern int SendModeSense(CMDDRIVE *drive, BYTE page_control, BYTE page_code);
/* page_control */
#define MSPC_CURRENT	0
#define MSPC_CHANGEABLE	1
#define MSPC_DEFAULT	2
#define MSPC_SAVED		3
extern int SendModeSelect(CMDDRIVE *drive, BYTE pf);
extern int SendReadToc(CMDDRIVE *drive, WORD track_sess_num, BYTE msf, BYTE format);
/* format */
#define RTF_TOC		0
#define RTF_SESS	1
#define RTF_FULLTOC	2
#define RTF_PMA		3
#define RTF_ATIP	4
#define RTF_CDTEXT	5
extern int SendReadDiscInfo(CMDDRIVE *drive);
extern int SendReadTrackInfo(CMDDRIVE *drive, WORD track_num);
extern int SendCloseTrackSession(CMDDRIVE *drive, BYTE immed, BYTE type, WORD track_num);
/* type */
#define CTST_CLOSETRACK		1
#define CTST_CLOSESESSION	2
extern int SendReadSubchannel(CMDDRIVE *drive, BYTE track_num, BYTE msf, BYTE subq, BYTE format);
#define RSCF_CURRENT_POS	1
#define RSCF_MCN			2
#define RSCF_ISRC			3
extern int SendReadCD(CMDDRIVE *drive, DWORD addr, DWORD len);
extern int SendReadFormatCapacities(CMDDRIVE *drive);
extern int SendFormatUnit(CMDDRIVE *drive, BYTE fmtdata, BYTE cmplist, BYTE format_code, WORD len);
#define FUFC_CDRW		7
#define FUFC_OTHER		1
extern int SendSetCdSpeed(CMDDRIVE *drive, WORD read_speed, WORD write_speed, BYTE rotctl);
extern int SendSetStreaming(CMDDRIVE *drive);
extern int SendSynchronizeCache(CMDDRIVE *drive, BYTE immed);
extern int SendReserveTrack(CMDDRIVE *drive, DWORD size);
extern int SendRead10(CMDDRIVE *drive, DWORD lba, WORD len, DWORD buflen);
extern int SendWrite10(CMDDRIVE *drive, DWORD lba, WORD len, DWORD buflen,
					   BOOL retry);
extern int SendSeek10(CMDDRIVE *drive, DWORD lba);
extern int SendSendCueSheet(CMDDRIVE *drive, void *cuesheet, DWORD len);
extern int SendReadBufferCapacity(CMDDRIVE *drive, BYTE block);
  
extern int SendLongRead12(CMDDRIVE *drive, DWORD lba, DWORD len, DWORD buflen,
						  DWORD total_blocks);
extern int SendLongReadCD(CMDDRIVE *drive, DWORD addr, DWORD len,
						  DWORD total_blocks);

extern int OpenTray(CMDDRIVE *drive);
extern int OpenTrayImmediate(CMDDRIVE *drive);
extern int CloseTray(CMDDRIVE *drive);
extern int GetDiscType(CMDDRIVE *drive, int *disc_type_ret, BOOL bWaitDisc);
extern int CheckReady(CMDDRIVE *drive, BOOL bWaitDisc);
extern int BlankDisc(CMDDRIVE *drive, BYTE type);
extern int WaitProgress(CMDDRIVE *drive, const char *message, BOOL meter1);
extern void DispCommandError(CMDDRIVE *drive);
extern int GetSubQ(CMDDRIVE *drive, DWORD lba, DWORD len);
extern int SetSpeed(CMDDRIVE *drive, int read_speed, int write_speed);


#ifdef __cplusplus
}
#endif

#endif /* !__CMD_H__ */
