using System;
using System.Collections.Generic;
using System.Text;

namespace MinorShift.Emuera.Sub
{
	internal abstract class EmueraException : ApplicationException
	{
		protected EmueraException(string errormes)
			: base(errormes)
		{
		}
	}

	/// <summary>
	/// emuera{̂ɋNƎvG[
	/// </summary>
	internal sealed class ExeEE : EmueraException
	{
		public ExeEE(string errormes)
			: base(errormes)
		{
		}
	}

	/// <summary>
	/// XNvgɋNƎvG[
	/// </summary>
	internal class CodeEE : EmueraException
	{
		public CodeEE(string errormes,ScriptPosition position)
			: base(errormes)
		{
			Position = position;
		}
		public CodeEE(string errormes)
			: base(errormes)
		{
			Position = null;
		}
		public ScriptPosition Position;
	}

	/// <summary>
	/// Save, Load̃G[
	/// </summary>
	internal class FileEE : EmueraException
	{
		public FileEE(string errormes)
			: base(errormes)
		{ }
	}

	/// <summary>
	/// G[ӏ\邽߂̈ʒuf[^B`Õf[^Ȃ̂ŃG[\ȊO̗RŎQƂׂł͂ȂB
	/// </summary>
	internal class ScriptPosition : IEquatable<ScriptPosition>, IEqualityComparer<ScriptPosition>
	{
		public ScriptPosition(string srcLine)
		{
			LineNo = -1;
			RowLine = srcLine;
			Filename = "";
		}
		public ScriptPosition(string srcFile, int srcLineNo, string srcLine)
		{
			LineNo = srcLineNo;
			RowLine = srcLine;
			Filename = srcFile;
			if (Filename == null)
				Filename = "";
		}
		public readonly int LineNo;
		public readonly string RowLine;
		public readonly string Filename;

		#region IEqualityComparer<ScriptPosition> o

		public bool Equals(ScriptPosition x, ScriptPosition y)
		{
			if((x == null)||(y == null))
				return false;
			return ((x.Filename == y.Filename) && (x.LineNo == y.LineNo));
		}

		public int GetHashCode(ScriptPosition obj)
		{
			return Filename.GetHashCode() ^ LineNo.GetHashCode();
		}

		#endregion

		#region IEquatable<ScriptPosition> o

		public bool Equals(ScriptPosition other)
		{
			return this.Equals(this, other);
		}

		#endregion
	}
}
