using System;
using System.Collections.Generic;
using System.Text;
using MinorShift.Emuera.Sub;
using MinorShift.Emuera.GameData;
using MinorShift.Emuera.GameData.Variable;

namespace MinorShift.Emuera.GameProc
{
	/// <summary>
	/// ߕ1sɑ钊ۃNX
	/// </summary>
	internal abstract class LogicalLine
	{
		protected ScriptPosition position;

		LogicalLine prevLine;
		LogicalLine nextLine;
		public ScriptPosition Position
		{
			get { return position; }
		}
		public LogicalLine PrevLine
		{
			get { return prevLine; }
			set { prevLine = value; }
		}

		public LogicalLine NextLine
		{
			get { return nextLine; }
			set { nextLine = value; }
		}
		public override string ToString()
		{
			if (position == null)
				return base.ToString();
			return string.Format("{0}:{1}:{2}", position.Filename, position.LineNo, position.RowLine);
		}

		protected bool isError;
		protected string errMes = "";

		public virtual string ErrMes
		{
			get { return errMes; }
			set { errMes = value; }
		}
		public virtual bool IsError
		{
			get { return isError; }
			set { isError = value; }
		}
	}

	/// <summary>
	/// RgsB
	/// </summary>
	internal sealed class CommentLine : LogicalLine
	{
		public CommentLine(ScriptPosition thePosition, string str)
		{
			base.position = thePosition;
			comment = str;
		}
		string comment;
		public override bool IsError
		{
			get { return false; }
		}
	}

	/// <summary>
	/// ȍsB
	/// </summary>
	internal sealed class InvalidLine : LogicalLine
	{
		public InvalidLine(ScriptPosition thePosition, string err)
		{
			base.position = thePosition;
			errMes = err;
		}
		public override bool IsError
		{
			get { return true; }
		}
	}

	/// <summary>
	/// ߕ
	/// </summary>
	internal sealed class InstructionLine : LogicalLine
	{
		public InstructionLine(ScriptPosition thePosition, BuiltInFunctionCode theFunc, string theArg)
		{
			base.position = thePosition;
			this.func = theFunc;
			this.argstr = theArg;
		}
		public InstructionLine(ScriptPosition thePosition, BuiltInFunctionCode theFunc, string dest, string theArg)
		{
			base.position = thePosition;
			this.func = theFunc;
			this.assigndest = dest;
			this.argstr = theArg;
		}
		readonly BuiltInFunctionCode func;
		readonly string argstr;
		readonly string assigndest;
		Int64 subData = 0;
		Argument arg = null;
		public BuiltInFunctionCode Function
		{
			get { return func; }
		}
		public string ArgumentStr
		{
			get { return argstr; }
		}
		public Argument Argument
		{
			get { return arg; }
			set { arg = value; }
		}
		public string AssignmentDestStr
		{
			get { return assigndest; }
		}

		/// <summary>
		/// JԂ̏IL
		/// </summary>
		public Int64 LoopEnd
		{
			get { return subData; }
			set { subData = value; }
		}

		FixedVariablePointer cnt;
		/// <summary>
		/// JԂɂϐL
		/// </summary>
		public FixedVariablePointer LoopCounter
		{
			get { return cnt; }
			set { cnt = value; }
		}

		Int64 step;
		/// <summary>
		/// JԂ̂тɑlL
		/// </summary>
		public Int64 LoopStep
		{
			get { return step; }
			set { step = value; }
		}

		private LogicalLine jumpto = null;
		private LogicalLine jumptoendif = null;

		public LogicalLine JumpToEndif
		{
			get { return jumptoendif; }
			set { jumptoendif = value; }
		}

		public LogicalLine JumpTo
		{
			get { return jumpto; }
			set { jumpto = value; }
		}

	}


	/// <summary>
	/// t@C̎n[ƏI[
	/// </summary>
	internal sealed class NullLine : LogicalLine { }

	/// <summary>
	/// @Ŏn܂郉xs
	/// </summary>
	internal sealed class FunctionLabelLine : LogicalLine, IComparable<FunctionLabelLine>
	{
		public FunctionLabelLine(ScriptPosition thePosition, string labelname, List<VariableToken> args)
		{
			base.position = thePosition;
			this.labelname = labelname;
			if ((args != null) && (args.Count > 0))
			{
				this.arg = new VariableToken[args.Count];
				args.CopyTo(this.arg);
			}
			else
				this.arg = new VariableToken[0];
		}
		readonly string labelname = "";
        readonly VariableToken[] arg;

		int priority = 0;
		bool isSingle = false;
		int index = -1;

		public string LabelName
		{
			get { return labelname; }
		}

		public int Priority
		{
			get { return priority; }
			set { priority = value; }
		}
		public bool IsSingle
		{
			get { return isSingle; }
			set { isSingle = value; }
		}
		public int Index
		{
			get { return index; }
			set { index = value; }
		}
		public VariableToken[] Arg
        {
            get { return arg; }
        }
		private int depth = -1;
		public int Depth
		{
			get { return depth; }
			set { depth = value; }
		}
		#region IComparable<FunctionLabelLine> o

		public int CompareTo(FunctionLabelLine other)
		{
			if(priority != other.priority)
				return priority.CompareTo(other.priority);
			return index.CompareTo(other.index);
		}

		#endregion
	}

	/// <summary>
	/// $Ŏn܂郉xs
	/// </summary>
	internal sealed class GotoLabelLine : LogicalLine, IEqualityComparer<GotoLabelLine>
	{
		public GotoLabelLine(ScriptPosition thePosition, string labelname)
		{
			base.position = thePosition;
			this.labelname = labelname;
		}
		readonly string labelname = "";
		FunctionLabelLine parentFunction = null;
		public string LabelName
		{
			get { return labelname; }
		}

		public void SetParentFunction(FunctionLabelLine parent)
		{
			parentFunction = parent;
		}

		public FunctionLabelLine ParentFunction
		{
			get { return parentFunction; }
		}


		#region IEqualityComparer<GotoLabelLine> o

		public bool Equals(GotoLabelLine x, GotoLabelLine y)
		{
			if ((x == null) || (y == null))
				return false;
			return ((x.parentFunction == y.parentFunction) && (x.labelname == y.labelname));
		}

		public int GetHashCode(GotoLabelLine obj)
		{
			return labelname.GetHashCode() ^ parentFunction.GetHashCode();
		}

		#endregion
	}

	/// <summary>
	/// x̃Wv̎BErbt@Cǂݍݎɍ쐬
	/// </summary>
	internal sealed class LabelDictionary
	{
		Dictionary<string, List<FunctionLabelLine>> labelAtDic = new Dictionary<string, List<FunctionLabelLine>>();
		List<GotoLabelLine> labelDollarList = new List<GotoLabelLine>();
		int count;

		public int Count { get { return count; } }
		public bool IsOverride(FunctionLabelLine point)
		{
			string id = point.LabelName;
			if (!labelAtDic.ContainsKey(id))
				return false;
			switch (id)
			{
				case "EVENTTRAIN":
				case "EVENTFIRST":
				case "EVENTCOM":
				case "EVENTCOMEND":
				case "EVENTEND":
				case "EVENTSHOP":
				case "EVENTBUY":
				case "EVENTTURNEND":

				case "EVENTLOAD":
					return false;
			}
			List<FunctionLabelLine> labelList = labelAtDic[id];
			return labelList.Count > 1;
		}

		public void AddLabel(FunctionLabelLine point)
		{
			string id = point.LabelName;
			if (labelAtDic.ContainsKey(id))
			{
				labelAtDic[id].Add(point);
			}
			else
			{
				List<FunctionLabelLine> labelList = new List<FunctionLabelLine>();
				labelAtDic.Add(id, labelList);
				labelAtDic[id].Add(point);
			}
			point.Index = count;
			count++;
		}

		public bool AddLabelDollar(GotoLabelLine point)
		{
			string id = point.LabelName;
			foreach (GotoLabelLine label in labelDollarList)
			{
				if (label == point)
					return false;
			}
			labelDollarList.Add(point);
			return true;
		}

		public List<FunctionLabelLine> GetLabels(string key)
		{
			if (labelAtDic.ContainsKey(key))
				return labelAtDic[key];
			return new List<FunctionLabelLine>();
		}

		public FunctionLabelLine GetLabel(string key)
		{
			if (labelAtDic.ContainsKey(key))
				return labelAtDic[key][0];
			return null;
		}

		public List<FunctionLabelLine> GetAllLabels()
		{
			List<FunctionLabelLine> ret = new List<FunctionLabelLine>();
			foreach (List<FunctionLabelLine> list in labelAtDic.Values)
				ret.AddRange(list);
			return ret;
		}

		public GotoLabelLine GetLabelDollar(string key, FunctionLabelLine labelAtLine)
		{
			foreach (GotoLabelLine label in labelDollarList)
				if ((label.LabelName == key) && (label.ParentFunction == labelAtLine))
					return label;
			return null;
		}
	}




}