package elazyrest.core.provider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;

/**
 * 
 * @author kaz
 *
 */
public class MessageResouceLoader {
	private static Object lock = new Object();
	private static Log log = LogFactory.getLog(MessageResouceLoader.class);

	public static MessageResourceBundle getMessageResource(String resourceName, String locale) {
		MessageResourceBundle messageResource = null;
		String key = resourceName +"_" +locale;

		if (SingletonProvider.contains(key)) {
			return (MessageResourceBundle)SingletonProvider.get(key);
		}
		synchronized(lock) {
			if (!SingletonProvider.contains(key)) {
				try {
					messageResource
					= new MessageResourceBundle(ResourceBundleEx.getBundle(resourceName, locale));
					SingletonProvider.set(key, messageResource);
				}
				catch (Exception e) {
					//
				}
			}
			else {
				messageResource = (MessageResourceBundle)SingletonProvider.get(key); 
			}
		}
		return messageResource;
	}
}
