package org.j69.eewiki.wiki.transformer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 単純なキーワード（データの外側を挟むタグがない）を処理する
 *
 * BasicDataLine で処理するキーワード
 * ---- : <hr>
 * *** : <h4>
 * ** : <h3>
 * * : <h2>
 * : <p>（何もない場合）
 * [通常文字列] : [通常文字列]
 *
 * @see DataLineCreator
 */
public class BasicDataLine implements DataLine {
    private String keyword_,            //キーワード（置き換え対象）
                    lineData_,          //データ
                    dataHoldTag_;       //データ自体をはさむタグ

    private static final Map tagMap_ = new HashMap();
    private static final String[] tags_;
	private static final int allowEnable_ = 10; //戻る矢印が適応される行数

    static {
        tagMap_.put("----", "hr");
        tagMap_.put("***", "h4");
        tagMap_.put("**", "h3");
        tagMap_.put("*", "h2");
        tags_ = (String[])tagMap_.keySet().toArray(new String[0]);
        Arrays.sort(tags_, new DataLineComparator());
    }

    /**
     * 初期化
     *
     * @param lineData データ
     **/
    public void init(String lineData) {

        String tempKey;
        for (int i = 0; i < tags_.length; i++) {
            tempKey = tags_[i];
            if(fastIndex(lineData, tempKey)) {
                keyword_ = tempKey;
                lineData_ = lineData.substring(keyword_.length());
                dataHoldTag_ = (String)tagMap_.get(tempKey);
                break;
            }
        }

        //通常文字列
        if(keyword_ == null) {
            keyword_ = "";
            lineData_ = lineData;
            dataHoldTag_ = "";
        }
    }

    /**
     * 行頭キーワード取得
     *
     * @return 行頭キーワード
     **/
    public String getKeyword() {
        return keyword_;
    }

    /**
     * データの外側を挟む開始タグ取得
     *
     * @return 長さ0の文字列「""」
     **/
    public String openTag(DataLine oldLine) {
        return "";
    }

    /**
     * データの外側を挟む終了タグ取得
     *
     * @return 長さ0の文字列「""」
     **/
    public String closeTag(DataLine newLine) {
        return "";
    }

    /**
     * 行データ取得
     *
     * @return 行データ
     **/
    public String get(int row) {
        if(dataHoldTag_.length() > 0 && !dataHoldTag_.toLowerCase().equals("hr")) {
        	//戻る矢印の適用
			if (row > allowEnable_ && (dataHoldTag_.equals("h2") 
			            || dataHoldTag_.equals("h3"))) {
				return "<" + dataHoldTag_ + ">" + "<a name=\"postion_" + row + "\">" +
						lineData_ + "</a>&nbsp;&nbsp;<span class=\"returnallow\"><a href=\"#postion_0\">Λ</a></span></" + dataHoldTag_ + ">\n";
			}
			else {
				return "<" + dataHoldTag_ + ">" + "<a name=\"postion_" + row + "\">" +
						lineData_ + "</a></" + dataHoldTag_ + ">\n";
			}
        } else {
			if(dataHoldTag_.length() > 0 && dataHoldTag_.toLowerCase().equals("hr")) {
				return lineData_ + "<hr>\n";
 			}
			else {
				return lineData_ + "<br>\n";
			}
        }
    }

    /**
     * 文字列中の先頭にキーワードがあるかどうか
     *
     * @param str 対象文字列
     * @param keyword キーワード
     * @return true キーワードあり、false キーワードなし
     **/
    private static boolean fastIndex(String str, String keyword) {
        int index = str.indexOf(keyword);
        return ( index == 0 ? true : false );
    }
}
