package org.j69.eewiki.wiki;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;

import org.j69.eewiki.util.ExtensionFilter;
import org.j69.eewiki.util.WebUtil;

/**
 * Wiki Utility Class
 * @version $Revision: 1.2 $ $Date: 2004/03/03 05:59:51 $
 */
public class WikiUtil {
    private static final String SEP = File.separator;
    private static final int WIKI_NAME_MIN_LENGTH = 1;
	private static final int WIKI_NAME_MAX_LENGTH = 256;

    /**
     * WikiWord名として有効か？ファイル名として使えない物を削除
     * @param wikiWorkName WikiWord名
     */
    public static boolean validWikiWordName(String name) {

        if(name == null) return false;

        if(name.length() < WIKI_NAME_MIN_LENGTH) return false;
		if(name.length() > WIKI_NAME_MAX_LENGTH) return false;

        if(name.indexOf('\\') != -1) return false;
        if(name.indexOf('/') != -1) return false;
        if(name.indexOf('.') != -1) return false;

        return ( true );

    }
    /**
     * 対象ディレクトリ内のテキストファイルないの検索。
     * textをファイル内かファイル名に含むファイルの一覧を返却。
     * @param dir 対象ディレクトリ
     * @param text 検索文字列
     * @return File[] 結果のファイルリスト
     * @throws IOException
     */
    public static File[] grep(File dir, String text) throws IOException {
        ExtensionFilter filter = new ExtensionFilter("txt");

        File[] files = dir.listFiles(filter);
        return grep(files, text);
    }
    /**
     * 対象ディレクトリ内のテキストファイルないの検索。
     * textをファイル内かファイル名に含むファイルの一覧を返却。
     * @param text 検索文字列
     * @return File[] 結果のファイルリスト
     * @throws IOException
     */
    public static File[] grep(File[] files, String text) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < files.length; i++) {
            File file = files[i];
            if(find(file, text)) {
                list.add(file);
            }
        }
        return (File[]) list.toArray(new File[0]);
    }
    /**
     * 指定ファイル内のテキストを検索と判定。
     * ファイル内の文字列・ファイル名にtext含む場合trueを返します。
     * @param file ファイル
     * @param text 検索文字列
     * @return boolean 対象文字列を含むファイルならtrue, それ以外はfalse
     * @throws IOException
     */
    public static boolean find(File file, String text) {
        // ファイル名に対象文字列が含まれていたらtrue
        if(find(file.getName(), text)) return true;

        boolean flg = false;
        try {
            flg = find(new InputStreamReader(
                        new FileInputStream(file), WebUtil.SHIFT_JIS), text);

        } catch (IOException ex) {
            ex.printStackTrace();
        }

        return flg;
    }
    /**
     * 指定リーダ内のテキストを検索と判定。
     * リーダ内の文字列にtext含む場合trueを返します。
     * @param reader リーダ
     * @param text 検索文字列
     * @return boolean 対象文字列を含めばtrue, それ以外はfalse
     * @throws IOException
     */
    public static boolean find(Reader reader, String text) throws IOException {

        if(text == null || text.equals("")) return false;

        BufferedReader in = null;
        try {
            in = new BufferedReader(reader);
            String str = null;
            while((str = in.readLine()) != null) {
                if(find(str, text)) return true;
            }
        } finally {
            if(in != null) { in.close(); }
        }
        return false;
    }
    /**
     * 文字列strにtextを含無かどうかの判定。
     * @param str 文字列
     * @param text 検索文字列
     * @return boolean true - textを含む, false - textを含まない。
     */
    public static boolean find(String str, String text) {
        return find(str, text, true);
    }
    /**
     * 文字列strにtextを含無かどうかの判定。
     * @param str 文字列
     * @param text 検索文字列
     * @param flg 大文字・小文字を区別しないかどうか true=区別しない,false=区別する
     * @return boolean true - textを含む, false - textを含まない。
     */
    public static boolean find(String str, String text, boolean flg) {
        if(text == null || text.equals("")) return false;

        if(flg) {
            if(str.toUpperCase().indexOf(text.toUpperCase()) != -1)
                return true;
            else
                return false;
        } else {
            if(str.indexOf(text) != -1)
                return true;
            else
                return false;
        }
    }

    /**
     * StackTraceを出力
     */
    public static String getStackTrace(Throwable ex)  throws IOException {

        StringWriter writer = new StringWriter();
        ex.printStackTrace(new PrintWriter(writer));
        String str = writer.getBuffer().toString();
        str = WebUtil.addBrTag(str);
        str = WebUtil.escapeSpace(str);

        return str;
    }
}