package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.SimpleCrypt;
import org.j69.eewiki.wiki.Wiki;

/**
 * ViewpageAction
 * Wikiコンテンツを表示する際に呼ばれるアクション
 * @author J.r0ck
 *
 */
public class ViewpageAction extends org.apache.struts.action.Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_View = "View";

    /**
     * Logging output for this plug in instance.
     */
    private Log log = LogFactory.getLog(this.getClass());

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

		//http://localhost:8080/eewiki-0.2/Viewpage.do?passwd=xxxxxされた場合
		if (request.getParameter("passwd") != null) {
			request.setAttribute("error_id" , SimpleCrypt.genMD5String(request.getParameter("passwd")));
		}

        //Wiki作成
        Wiki wiki = new Wiki(request.getParameter("pid"), request, msg);

        //表示するコンテンツのタイプとコンテンツを設定
		request.setAttribute("queryword", request.getParameter("qword"));
        request.setAttribute("contentType", "content");
        request.setAttribute("content", wiki);

        return mapping.findForward(FORWARD_View);

    }

}
