package org.j69.eewiki.action;

import java.util.Vector;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;
import org.j69.eewiki.wiki.WikiList;

public class RecentAction extends org.apache.struts.action.Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    public ActionForward execute(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //コンテンツ格納(Listページを設定)
		String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.new"));
        Wiki wiki = new Wiki(linkName, request, msg);
        request.setAttribute("content" , wiki);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "recent");

        //WikiListの作成
        WikiList wikilist = new WikiList(wiki.getBasePath());
        Vector datas = wikilist.getWikiFiles(null, "date", true);
        request.setAttribute("lists", datas);

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Recentpage");

        return mapping.findForward(FORWARD_View);

    }

}