/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.expr.DefaultTruthExpr;
import org.jaxen.expr.Expr;

abstract class DefaultRelationalExpr
extends DefaultTruthExpr {
    public DefaultRelationalExpr(Expr lhs, Expr rhs) {
        super(lhs, rhs);
    }

    public Object evaluate(Context context) throws JaxenException {
        Object lhsValue = this.getLHS().evaluate(context);
        Object rhsValue = this.getRHS().evaluate(context);
        Navigator nav = context.getNavigator();
        if (this.bothAreSets(lhsValue, rhsValue)) {
            return this.evaluateSetSet((List)lhsValue, (List)rhsValue, nav);
        }
        if (this.eitherIsSet(lhsValue, rhsValue)) {
            if (this.isSet(lhsValue)) {
                if (this.isString(rhsValue)) {
                    return this.evaluateSetString((List)lhsValue, (String)rhsValue, nav);
                }
                if (this.isNumber(rhsValue)) {
                    return this.evaluateSetNumber((List)lhsValue, (Number)rhsValue, nav);
                }
                if (this.isBoolean(rhsValue)) {
                    return this.evaluateSetBoolean((List)lhsValue, (Boolean)rhsValue);
                }
            } else {
                if (this.isString(lhsValue)) {
                    return this.evaluateStringSet((String)lhsValue, (List)rhsValue, nav);
                }
                if (this.isNumber(lhsValue)) {
                    return this.evaluateNumberSet((Number)lhsValue, (List)rhsValue, nav);
                }
                if (this.isBoolean(lhsValue)) {
                    return this.evaluateSetBoolean((List)rhsValue, (Boolean)rhsValue);
                }
            }
        }
        return this.evaluateObjectObject(lhsValue, rhsValue);
    }

    protected Object evaluateNumberSet(Number theNum, List theSet, Navigator nav) {
        return this.evaluateSetNumber(theSet, theNum, true, nav);
    }

    protected abstract Object evaluateObjectObject(Object var1, Object var2);

    protected abstract Object evaluateSetBoolean(List var1, Boolean var2);

    protected Object evaluateSetNumber(List theSet, Number theNum, Navigator nav) {
        return this.evaluateSetNumber(theSet, theNum, false, nav);
    }

    protected abstract Object evaluateSetNumber(List var1, Number var2, boolean var3, Navigator var4);

    protected abstract Object evaluateSetSet(List var1, List var2, Navigator var3);

    protected Object evaluateSetString(List theSet, String theStr, Navigator nav) {
        return this.evaluateSetString(theSet, theStr, false, nav);
    }

    protected abstract Object evaluateSetString(List var1, String var2, boolean var3, Navigator var4);

    protected Object evaluateStringSet(String theStr, List theSet, Navigator nav) {
        return this.evaluateSetString(theSet, theStr, true, nav);
    }

    public String toString() {
        return "[(DefaultRelationalExpr): " + this.getLHS() + ", " + this.getRHS() + "]";
    }
}

