/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.List;
import org.jaxen.Navigator;
import org.jaxen.expr.DefaultRelationalExpr;
import org.jaxen.expr.Expr;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.StringFunction;

class DefaultLessThanEqualExpr
extends DefaultRelationalExpr {
    public DefaultLessThanEqualExpr(Expr lhs, Expr rhs) {
        super(lhs, rhs);
    }

    protected Object evaluateObjectObject(Object lhs, Object rhs) {
        if (this.bothAreBoolean(lhs, rhs)) {
            return lhs.equals(rhs) ? Boolean.TRUE : Boolean.FALSE;
        }
        Comparable lhsComp = (Comparable)lhs;
        Comparable rhsComp = (Comparable)rhs;
        if (lhsComp.compareTo(rhsComp) <= 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetBoolean(List theSet, Boolean theBool) {
        return BooleanFunction.evaluate(theSet).equals(theBool) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Object evaluateSetNumber(List theSet, Number theNum, boolean reverse, Navigator nav) {
        int setSize = theSet.size();
        Comparable setElement = null;
        int i = 0;
        while (i < setSize) {
            setElement = (Comparable)((Object)NumberFunction.evaluate(theSet.get(i), nav));
            if (reverse ? setElement.compareTo(theNum) >= 0 : setElement.compareTo(theNum) <= 0) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetSet(List lhsSet, List rhsSet, Navigator nav) {
        int lhsSetSize = lhsSet.size();
        int rhsSetSize = rhsSet.size();
        String lhsStr = null;
        String rhsStr = null;
        int i = 0;
        while (i < lhsSetSize) {
            lhsStr = StringFunction.evaluate(lhsSet.get(i), nav);
            int j = 0;
            while (j < rhsSetSize) {
                rhsStr = StringFunction.evaluate(rhsSet.get(j), nav);
                if (lhsStr.compareTo(rhsStr) <= 0) {
                    return Boolean.TRUE;
                }
                ++j;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetString(List theSet, String theStr, boolean reverse, Navigator nav) {
        int setSize = theSet.size();
        String setElement = null;
        int i = 0;
        while (i < setSize) {
            setElement = StringFunction.evaluate(theSet.get(i), nav);
            if (reverse ? setElement.compareTo(theStr) >= 0 : setElement.compareTo(theStr) <= 0) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    public String getOperator() {
        return "<=";
    }
}

