package org.j69.eewiki.wiki.transformer;


/**
 * キーワード「---」「--」「-」を処理する
 *
 * --- : <ul><ul><ul><li>[通常文字列]</li></ul></ul></ul>
 * -- : <ul><ul><li>[通常文字列]</li></ul></ul>
 * - : <ul><li>[通常文字列]</li></ul>
 *
 * @see DataLineCreator
 */
public class ULDataLine implements DataLine {
    private String keyword_,                //キーワード（置き換え対象）
                    lineData_,              //データ
                    dataHoldTag_ = "li",    //データ自体をはさむタグ
                    outerHoldTag_ = "ul",   //データの外側をはさむタグ
                    baseSpaces_;
    /**
     * 初期化
     *
     * @param lineData 行データ（キーワード分解前）
     **/
    public void init(String lineData) {
        if (lineData.indexOf("---") == 0) {
            keyword_ = "---";
            baseSpaces_ = "  ";
        } else if(lineData.indexOf("--") == 0) {
            keyword_ = "--";
            baseSpaces_ = " ";
        } else {
            keyword_ = "-";
            baseSpaces_ = "";
        }

        lineData_ = lineData.substring(getKeyword().length());
    }

    /**
     * 行頭キーワード取得
     *
     * @return 行頭キーワード
     **/
    public String getKeyword() {
        return keyword_;
    }

    /**
     * データの外側を挟む開始タグ（<ul>）取得
     *
     * @param oldLine 前の行データ
     * @return <ul>
     **/
    public String openTag(DataLine oldLine) {
        if(oldLine != null && oldLine instanceof ULDataLine) {
            //前の行も UL の場合
            ULDataLine oldULLine = (ULDataLine)oldLine;
            int depth = getKeyword().length() - oldULLine.getKeyword().length();
            int type = getKeyword().length();
            switch(depth) {
                case 0 :
                    //前の UL と同じ深さの場合はなし
                    return "";
                case 1 :
                    return baseSpaces_ + "<" + outerHoldTag_ + " class=\"list"+ type + "\">\n";
                case 2 :
                    return " <" + outerHoldTag_ + " class=\"list"+ type + "\">\n" +
							baseSpaces_ + "<" + outerHoldTag_ + " class=\"list"+ type + "\">\n";
                default :
                    return "";
            }
        } else {
            int depth = getKeyword().length();
            switch(depth) {
                case 1 :
                    return baseSpaces_ + "<" + outerHoldTag_ + " class=\"list"+ depth + "\">\n";
                case 2 :
                    return "<" + outerHoldTag_ + " class=\"list"+ depth + "\">\n" +
							baseSpaces_ + "<" + outerHoldTag_ + " class=\"list"+ depth + "\">\n";
                case 3 :
                    return "<" + outerHoldTag_ + " class=\"list"+ depth + "\">\n" +
                            " <" + outerHoldTag_ + " class=\"list"+ depth + "\">\n" +
							baseSpaces_ + "<" + outerHoldTag_ + " class=\"list"+ depth + "\">\n";
                default :
                    return "";
            }
        }
    }

    /**
     * 行頭に付加する半角スペース（" "）取得
     *
     * @param spaceNum スペース数
     * @return 行頭に付加するスペース
     **/
    private String getBaseSpaces(int spaceNum){
        StringBuffer buf = new StringBuffer();
        for(int i = 0 ; i < spaceNum ; i++) {
            buf.append(" ");
        }

        return buf.toString();
    }

    /**
     * データの外側を挟む終了タグ（<ul>）取得
     *
     * @param oldLine 前の行データ
     * @return </ul>
     **/
    public String closeTag(DataLine newLine) {
        if(newLine != null && newLine instanceof ULDataLine) {
            //次の行も UL の場合
            ULDataLine oldULLine = (ULDataLine)newLine;
            int depth = getKeyword().length() - newLine.getKeyword().length();
            switch(depth) {
                case 0 :
                    //前の UL と同じ深さの場合はなし
                    return "";
                case 1 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n";
                case 2 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" +
                            " </" + outerHoldTag_ + ">\n";
                default :
                    return "";
            }
        } else {
            int depth = getKeyword().length();
            switch(depth) {
                case 1 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n";
                case 2 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" +
                            "</" + outerHoldTag_ + ">\n";
                case 3 :
                    return baseSpaces_ + "</" + outerHoldTag_ + ">\n" +
                            " </" + outerHoldTag_ + ">\n" +
                            "</" + outerHoldTag_ + ">\n";
                default :
                    return "";
            }
        }
    }

    /**
     * 行データ取得
     *
     * @return 行データ
     **/
    public String get(int row) {
        return baseSpaces_ + "<" + dataHoldTag_ + ">" + lineData_ + "</" + dataHoldTag_ + ">\n";
    }
}

