package org.j69.eewiki.wiki;

import org.j69.eewiki.util.UtilComparator;

/**
 * WikiListを日付でソートする
 * from mobwiki(mobstar)
 *
 */
public class DateComparator extends UtilComparator {
    public DateComparator(String order) {
        super.init(order);
    }

    protected int asc(Object data0, Object data1) {
        return String.CASE_INSENSITIVE_ORDER.compare(
            ((WikiFile)data0).getLastModified(), ((WikiFile)data1).getLastModified());
    }

    protected int desc(Object data0, Object data1) {
        return String.CASE_INSENSITIVE_ORDER.compare(
            ((WikiFile)data1).getLastModified(), ((WikiFile)data0).getLastModified());
    }
}
