package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;

/**
 * WordAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 05-31-2003
 *
 * XDoclet definition:
 * @struts:action path="/Word" name="QueryForm" input="/pages/Viewpage.vm" validate="true"
 * @struts:action-forward name="/Query.do" path="/Query.do"
 */
public class WordAction extends Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_Query = "Query";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //コンテンツ格納(検索ページを設定)
		String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.query"));
        Wiki wiki = new Wiki(linkName, request, msg);
        request.setAttribute("content" , wiki);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "query");

        return mapping.findForward(FORWARD_Query);

    }

}
