package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.SimpleCrypt;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;

public class SavepageAction extends org.apache.struts.action.Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    public ActionForward execute(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //ページIDパラメータの取得
        String pid = request.getParameter("pid");
		pid = WebUtil.escapeChar(pid);
		
        //コンテンツ格納
        Wiki wiki = new Wiki(WebUtil.getEncodeFileName(pid), request, msg);

		//Viewpageに遷移元を伝える
		request.setAttribute("from_id", "Savepage");

        //フォームBeanの値取得
        //fromが無い場合はEditFormを作成
        HttpSession session = request.getSession();
        if (form == null) {
            form = new EditForm();
            if ("request".equals(mapping.getScope()))
                request.setAttribute(mapping.getAttribute(), form);
            else
                session.setAttribute(mapping.getAttribute(), form);
        }
        EditForm editform = (EditForm) form;
        String action = editform.getAction();
        String content = editform.getContent();
		String touchtime = editform.getTouchtime().trim();
		String pageOwner = editform.getEditPageowner();
		
		//他者によるファイルの更新をチェック、誰かが保存していたら保存は拒否する
		String LastTime = wiki.getLastModified();
		if (!LastTime.equals(touchtime)) {
			request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.whotouch", ""));
			
			//表示するコンテンツのタイプを設定
			request.setAttribute("contentType", "content");

			request.setAttribute("content" , wiki);
			return mapping.findForward(FORWARD_View);
		}
		
        //プレビューの場合は、更新せず更新フォームにデータを返すだけ
        if (action.equals("preview")) {
            //フォームに値をセット
            editform.setContent(content);
            editform.setCmd("edit");
            editform.setNotimestamp(false);
            editform.setTouchtime(wiki.getLastModified());
            editform.setPassword("");
            editform.setPid(WebUtil.getEncodeFileName(pid));
			editform.setPageowner(pageOwner);

            //コンテンツ格納（保存前なのでキャッシュに書き込む）
            wiki.setCachePage(content);

            //表示するコンテンツのタイプを設定
            request.setAttribute("contentType", "preview");

            request.setAttribute("content" , wiki);
            return mapping.findForward(FORWARD_View);
        }

        //パスワードのチェック
        if (wiki.isUsepasswd() == 1) {
        	String shadow = config_.getConfig("define.admin.passwd");
        	String cryppass = SimpleCrypt.genMD5String(editform.getPassword());
        	
            if (!shadow.equals(cryppass)) {
                request.setAttribute("contentType", "content");
                request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.failpasswd", ""));

                //コンテンツ格納
                request.setAttribute("content" , wiki);
                return mapping.findForward(FORWARD_View);
            }
        }
    	
        //ページ更新
        wiki.setPageContent(editform.getContent(), !editform.getNotimestamp(), pageOwner);

        //コンテンツ格納
        request.setAttribute("content" , wiki);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "content");

        //削除の場合はメッセージ表示
        if (content.equals(null) || content.equals(""))
            request.setAttribute("error_id" , msg.getMessage(request.getLocale(), "error.killpage", pid));

        return mapping.findForward(FORWARD_View);

    }

}