package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.oro.text.perl.Perl5Util;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.plugin.WikiPlugin;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;

/** 
 * PluginSubmitAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-24-2003
 * 
 * XDoclet definition:
 * @struts:action validate="true"
 * @struts:action-forward name="/pages/Viewpage.vm" path="/pages/Viewpage.vm"
 */
public class PluginSubmitAction extends Action {

	static final private String FORWARD_View = "View";
	// コンフィグ
	private final static CacheConfig config_ = CacheConfig.getInstance( );

	/** 
	 * Method execute
	 * @param ActionMapping mapping
	 * @param ActionForm form
	 * @param HttpServletRequest request
	 * @param HttpServletResponse response
	 * @return ActionForward
	 * @throws Exception
	 */
	public ActionForward execute(
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {

			//メッセージリソース
			MessageResources msg = getResources(request);

			Perl5Util perl = new Perl5Util();
			
			PluginSubmitForm psForm = (PluginSubmitForm) form;

			//ページIDの取得
			String pid = WebUtil.getEncodeFileName(psForm.getPid());

			//実行するプラグインの取得
			String plugin =  psForm.getPlugin();
			plugin = "org.j69.eewiki.plugin.Plugin" + perl.substitute("s![\\r\\n]!!g", plugin);
			
			//フォームBeanへのLocale設定
			psForm.setLocale(WebUtil.getLocale(request));
			
			//Wiki作成
			Wiki wiki = new Wiki(pid, request, msg);
			
			//コマンドを実行し表示するコンテンツを取得
			Wiki destWiki = createWikiPlugin(plugin).submit(wiki, form);
			if (destWiki == null)  {
				request.setAttribute("content" , wiki);
			}
			else {
				request.setAttribute("content" , destWiki);
			}

			//表示するコンテンツのタイプとコンテンツを設定
			request.setAttribute("contentType", "content");

			return mapping.findForward(FORWARD_View);
	}

	/**
	 * WikiPlugin クラス作成.
	 * @param plugin クラス名
	 * @return WikiPlugin クラス
	 **/
	private WikiPlugin createWikiPlugin(String plugin)
		throws InstantiationException,
				IllegalAccessException,
				ClassNotFoundException {

		return (WikiPlugin) ((Class.forName(plugin)).newInstance());
	}

}
