package org.j69.eewiki.action;

import java.io.IOException;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

//import org.apache.oro.text.perl.Perl5Util;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;
import org.j69.eewiki.wiki.WikiFile;

/**
 * HelpAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-03-2003
 *
 * XDoclet definition:
 * @struts:action
 * @struts:action-forward name="/pages/Viewpage.vm" path="/pages/Viewpage.vm"
 */
public class HelpAction extends Action {

    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {
		
		//メッセージリソース
		MessageResources msg = getResources(request);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "content");

		Locale locale = WebUtil.getLocale(request);

//		String language = locale.getLanguage();
//		String pageId = "";
//		Perl5Util perl = new Perl5Util();
//		if (perl.match("m!^ja!", language)) {
//			pageId = config_.getConfig("define.pagename.help") + "_ja";			
//		}
//		else {
//			pageId = config_.getConfig("define.pagename.help");			
//		}

		String pageId = WebUtil.getEncodeFileName(getHelpContents(locale));
		
        //コンテンツ格納(Listページを設定)
		Wiki wiki = new Wiki(pageId, request, msg);
        request.setAttribute("content" , wiki);
		
        return mapping.findForward(FORWARD_View);

    }

	/**
	 * HelpページPIDを取得
	 **/
	private String getHelpContents(Locale locale) throws IOException {
		//Help用 WikiFile
		String helppage = "";
		String lang = locale.getLanguage();

		if (lang.equals("") || lang.equals(null) || lang.equals("ja-jp")) lang = "ja";
		
		if (lang.equals("") || lang.equals(null) || lang.equals("en")) {
			helppage = config_.getConfig("define.pagename.help");
		}
		else {
			helppage = config_.getConfig("define.pagename.help") + "_" + lang.trim();
			//ページが存在しなければデフォルトのローケル用ページ
			WikiFile wikifile = new WikiFile(helppage, true);
			if (!wikifile.isExists()) {
				helppage = config_.getConfig("define.pagename.help");
			}
		}
		return helppage;
	}


}
