package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.wiki.Wiki;

/**
 * FrozenAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-08-2003
 *
 * XDoclet definition:
 * @struts:action validate="true"
 * @struts:action-forward name="/pages/Viewpage.vm" path="/pages/Viewpage.vm"
 */
public class FrozenAction extends Action {

    static final private String FORWARD_View = "View";

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //Wiki作成
        Wiki wiki = new Wiki(request.getParameter("pid"), request, msg);

        //凍結
        wiki.setFrozen();

        //表示するコンテンツのタイプとコンテンツを設定
        request.setAttribute("contentType", "content");
        request.setAttribute("content" , wiki);

        return mapping.findForward(FORWARD_View);

    }

}
