package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;

/**
 * FormatAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-22-2003
 *
 * XDoclet definition:
 * @struts:action path="/Format" name="EditForm"
 * @struts:action-forward name="/pages/Viewpage.vm" path="/pages/Viewpage.vm"
 */
public class FormatAction extends Action {

    //------------------------------------------------------------ Local Forwards
    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    public ActionForward execute(ActionMapping mapping, ActionForm form,
        HttpServletRequest request, HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //ページIDパラメータの取得
        String pid = request.getParameter("pid");
        //コンテンツ格納
        Wiki wiki = new Wiki(pid, request, msg);

        EditForm editform = (EditForm) form;
        String content = editform.getContent();

        editform.setContent(content);
        editform.setCmd("edit");
        editform.setNotimestamp(false);
        editform.setTouchtime(wiki.getLastModified());
        editform.setPassword("");
        editform.setPid(pid);

        //コンテンツ格納（保存前なのでキャッシュに書き込む）
        wiki.setFormatContents(WebUtil.getLocale(request));

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "preview");
        request.setAttribute("content" , wiki);

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Format");

        return mapping.findForward(FORWARD_View);

    }

}
