package org.j69.eewiki.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import org.j69.eewiki.util.CacheConfig;
import org.j69.eewiki.util.WebUtil;
import org.j69.eewiki.wiki.Wiki;
import org.j69.eewiki.wiki.WikiAttachment;

/**
 * AttListAction.java created by EasyStruts - XsltGen.
 * http://easystruts.sf.net
 * created on 06-15-2003
 *
 * XDoclet definition:
 * @struts:action validate="true"
 * @struts:action-forward name="Viewpage.vm" path="Viewpage.vm"
 */
public class AttListAction extends Action {

    static final private String FORWARD_View = "View";

    // コンフィグ
    private final static CacheConfig config_ = CacheConfig.getInstance( );

    /**
     * Method execute
     * @param ActionMapping mapping
     * @param ActionForm form
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     * @return ActionForward
     * @throws Exception
     */
    public ActionForward execute(
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response)
        throws Exception {

		//メッセージリソース
		MessageResources msg = getResources(request);

        //コンテンツ格納(Listページを設定)
        String linkName = WebUtil.getEncodeFileName(config_.getConfig("define.pagename.attlist"));
        Wiki wiki = new Wiki(linkName, request, msg);
        request.setAttribute("content" , wiki);

        //表示するコンテンツのタイプを設定
        request.setAttribute("contentType", "attlists");

        //添付ファイル一覧の作成
        request.setAttribute("lists", WikiAttachment.getAllList());

        //Viewpageに遷移元を伝える
        request.setAttribute("from_id", "Listpage");

        return mapping.findForward(FORWARD_View);

    }

}
