/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.impl;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.resources.ResourcesException;
import org.apache.commons.resources.ResourcesKeyException;
import org.apache.commons.resources.impl.ResourcesBase;

public class ResourceBundleResources
extends ResourcesBase {
    protected String base = null;
    protected Map bundles = new HashMap();
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$commons$resources$impl$ResourceBundleResources == null ? (class$org$apache$commons$resources$impl$ResourceBundleResources = ResourceBundleResources.class$("org.apache.commons.resources.impl.ResourceBundleResources")) : class$org$apache$commons$resources$impl$ResourceBundleResources));
    static /* synthetic */ Class class$org$apache$commons$resources$impl$ResourceBundleResources;

    public ResourceBundleResources(String name, String base) {
        super(name);
        this.base = base;
    }

    public void init() throws ResourcesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing for base name '" + this.base + "'"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourcesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finalizing for base name '" + this.base + "'"));
        }
        Map map = this.bundles;
        synchronized (map) {
            Iterator loaders = this.bundles.keySet().iterator();
            while (loaders.hasNext()) {
                ClassLoader loader = (ClassLoader)loaders.next();
                ((Map)this.bundles.get(loader)).clear();
            }
            this.bundles.clear();
        }
    }

    public String getBase() {
        return this.base;
    }

    public byte[] getBytes(String key, Locale locale, TimeZone timeZone) throws ResourcesException {
        throw new UnsupportedOperationException();
    }

    public InputStream getInputStream(String key, Locale locale, TimeZone timeZone) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String key, Locale locale, TimeZone timeZone) {
        try {
            ResourceBundle bundle = this.getBundle(locale, timeZone);
            return bundle.getObject(key);
        }
        catch (MissingResourceException e) {
            if (this.isReturnNull()) {
                return null;
            }
            throw new ResourcesKeyException(key);
        }
    }

    public Reader getReader(String key, Locale locale, TimeZone timeZone) {
        throw new UnsupportedOperationException();
    }

    public String getString(String key, Locale locale, TimeZone timeZone) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Retrieving message for key '" + key + "' for locale '" + locale + "'"));
        }
        try {
            ResourceBundle bundle = this.getBundle(locale, timeZone);
            String message = bundle.getString(key);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Retrieved message is '" + message + "'"));
            }
            return message;
        }
        catch (ClassCastException e) {
            throw new ResourcesException(e);
        }
        catch (MissingResourceException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No message found");
            }
            if (this.isReturnNull()) {
                return null;
            }
            throw new ResourcesKeyException(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceBundle getBundle(Locale locale, TimeZone timeZone) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Map map = this.bundles;
        synchronized (map) {
            ResourceBundle bundle;
            HashMap<Locale, ResourceBundle> loaderMap;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            if ((loaderMap = (HashMap<Locale, ResourceBundle>)this.bundles.get(loader)) == null) {
                loaderMap = new HashMap<Locale, ResourceBundle>();
                this.bundles.put(loader, loaderMap);
            }
            if ((bundle = (ResourceBundle)loaderMap.get(locale)) == null) {
                bundle = ResourceBundle.getBundle(this.base, locale, loader);
                loaderMap.put(locale, bundle);
            }
            return bundle;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

