/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.PoolableConnection;
import org.apache.commons.dbcp.PoolingConnection;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory {
    protected ConnectionFactory _connFactory = null;
    protected String _validationQuery = null;
    protected ObjectPool _pool = null;
    protected KeyedObjectPoolFactory _stmtPoolFactory = null;
    protected boolean _defaultReadOnly = false;
    protected boolean _defaultAutoCommit = true;
    protected AbandonedConfig _config = null;

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit) throws Exception {
        this._connFactory = connFactory;
        this._pool = pool;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public PoolableConnectionFactory(ConnectionFactory connFactory, ObjectPool pool, KeyedObjectPoolFactory stmtPoolFactory, String validationQuery, boolean defaultReadOnly, boolean defaultAutoCommit, AbandonedConfig config) {
        this._connFactory = connFactory;
        this._pool = pool;
        this._config = config;
        this._pool.setFactory((PoolableObjectFactory)this);
        this._stmtPoolFactory = stmtPoolFactory;
        this._validationQuery = validationQuery;
        this._defaultReadOnly = defaultReadOnly;
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public synchronized void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(ObjectPool pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized void setStatementPoolFactory(KeyedObjectPoolFactory stmtPoolFactory) {
        this._stmtPoolFactory = stmtPoolFactory;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public synchronized Object makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool stmtpool = this._stmtPoolFactory.createPool();
            conn = new PoolingConnection(conn, stmtpool);
            stmtpool.setFactory((KeyedPoolableObjectFactory)((PoolingConnection)conn));
        }
        return new PoolableConnection(conn, this._pool, this._config);
    }

    public void destroyObject(Object obj) throws Exception {
        if (obj instanceof PoolableConnection) {
            try {
                ((PoolableConnection)obj).reallyClose();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException e) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized boolean validateObject(Object obj) {
        if (obj instanceof Connection) {
            String query = this._validationQuery;
            Connection conn = (Connection)obj;
            try {
                if (conn.isClosed()) {
                    return false;
                }
            }
            catch (SQLException e) {
                return false;
            }
            if (null != query) {
                ResultSet rset;
                Statement stmt;
                block20: {
                    stmt = null;
                    rset = null;
                    stmt = conn.createStatement();
                    rset = stmt.executeQuery(query);
                    if (!rset.next()) break block20;
                    boolean bl = true;
                    Object var9_10 = null;
                    try {
                        rset.close();
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                    return bl;
                }
                boolean bl = false;
                Object var9_11 = null;
                try {
                    rset.close();
                }
                catch (Exception t) {
                    // empty catch block
                }
                try {
                    stmt.close();
                }
                catch (Exception t) {
                    // empty catch block
                }
                return bl;
                catch (Exception e) {
                    boolean bl2;
                    try {
                        bl2 = false;
                        Object var9_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        try {
                            rset.close();
                        }
                        catch (Exception t) {
                            // empty catch block
                        }
                        try {
                            stmt.close();
                        }
                        catch (Exception t) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        rset.close();
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                    try {
                        stmt.close();
                    }
                    catch (Exception t) {
                        // empty catch block
                    }
                    return bl2;
                }
            }
            return true;
        }
        return false;
    }

    public void passivateObject(Object obj) throws Exception {
        if (obj instanceof Connection) {
            Connection conn = (Connection)obj;
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        if (obj instanceof DelegatingConnection) {
            ((DelegatingConnection)obj).passivate();
        }
    }

    public void activateObject(Object obj) throws Exception {
        block5: {
            if (obj instanceof DelegatingConnection) {
                ((DelegatingConnection)obj).activate();
            }
            if (!(obj instanceof Connection)) break block5;
            Connection conn = (Connection)obj;
            try {
                conn.setAutoCommit(this._defaultAutoCommit);
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                conn.setReadOnly(this._defaultReadOnly);
            }
            catch (SQLException e) {}
        }
    }
}

