/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.servlet;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.view.DataInfo;
import org.apache.velocity.tools.view.ToolInfo;
import org.apache.velocity.tools.view.XMLToolboxManager;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.servlet.ServletToolInfo;
import org.dom4j.Element;
import org.dom4j.Node;

public class ServletToolboxManager
extends XMLToolboxManager {
    public static final String ELEMENT_SCOPE = "scope";
    public static final String ELEMENT_CREATE_SESSION = "create-session";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String SESSION_TOOLS_KEY = "org.apache.velocity.tools.view.tools.ServletToolboxManager.SessionTools";
    private ServletContext servletContext;
    private Map appTools;
    private ArrayList sessionToolInfo;
    private ArrayList requestToolInfo;
    private boolean createSession;
    private static HashMap managersMap = new HashMap();

    private ServletToolboxManager(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.appTools = new HashMap();
        this.sessionToolInfo = new ArrayList();
        this.requestToolInfo = new ArrayList();
        this.createSession = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized ServletToolboxManager getInstance(ServletContext servletContext, String string) {
        ServletToolboxManager servletToolboxManager;
        block14: {
            String string2;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((servletToolboxManager = (ServletToolboxManager)managersMap.get(string2 = servletContext.getRealPath(string))) == null) {
                InputStream inputStream;
                block13: {
                    inputStream = null;
                    inputStream = servletContext.getResourceAsStream(string);
                    if (inputStream == null) break block13;
                    Velocity.info((Object)("Using toolbox configuration file '" + string + "'"));
                    servletToolboxManager = new ServletToolboxManager(servletContext);
                    servletToolboxManager.load(inputStream);
                    managersMap.put(string2, servletToolboxManager);
                    Velocity.info((Object)"Toolbox setup complete.");
                }
                Object var8_5 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block14;
                }
                catch (Exception exception) {}
                break block14;
                {
                    catch (Exception exception) {
                        Velocity.error((Object)("Problem loading toolbox '" + string + "' : " + exception));
                        StringWriter stringWriter = new StringWriter();
                        exception.printStackTrace(new PrintWriter(stringWriter));
                        Velocity.error((Object)stringWriter.toString());
                        Object var8_6 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            break block14;
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return servletToolboxManager;
    }

    public void setCreateSession(boolean bl) {
        this.createSession = bl;
    }

    protected void log(String string) {
        Velocity.info((Object)("ServletToolboxManager: " + string));
    }

    protected boolean readElement(Element element) throws Exception {
        String string = element.getName();
        ToolInfo toolInfo = null;
        if (string.equalsIgnoreCase("tool")) {
            toolInfo = this.readToolInfo(element);
        } else if (string.equalsIgnoreCase("data")) {
            toolInfo = this.readDataInfo(element);
        } else {
            if (string.equalsIgnoreCase(ELEMENT_CREATE_SESSION)) {
                this.readCreateSession(element);
                return true;
            }
            this.log("Unreadable element: " + string);
            return false;
        }
        this.addTool(toolInfo);
        this.log("Added " + toolInfo.getClassname() + " as " + toolInfo.getKey());
        return true;
    }

    protected boolean readCreateSession(Element element) throws Exception {
        String string = element.getText();
        if (VALUE_YES.equalsIgnoreCase(string)) {
            this.setCreateSession(true);
        } else if (VALUE_NO.equalsIgnoreCase(string)) {
            this.setCreateSession(false);
        } else {
            this.log("Unknown value for create-session.  Valid options are 'yes' or 'no'.");
            return false;
        }
        this.log("create-session is set to " + this.createSession);
        return true;
    }

    protected ToolInfo readToolInfo(Element element) throws Exception {
        Node node = element.selectSingleNode("key");
        String string = node.getText();
        node = element.selectSingleNode("class");
        String string2 = node.getText();
        String string3 = "request";
        node = element.selectSingleNode(ELEMENT_SCOPE);
        if (node != null) {
            string3 = node.getText();
        }
        return new ServletToolInfo(string, string2, string3);
    }

    public void addTool(ToolInfo toolInfo) {
        if (toolInfo instanceof DataInfo) {
            this.appTools.put(toolInfo.getKey(), toolInfo.getInstance(null));
        } else if (toolInfo instanceof ServletToolInfo) {
            ServletToolInfo servletToolInfo = (ServletToolInfo)toolInfo;
            if (servletToolInfo.getScope().equalsIgnoreCase("request")) {
                this.requestToolInfo.add(servletToolInfo);
            } else if (servletToolInfo.getScope().equalsIgnoreCase("session")) {
                this.sessionToolInfo.add(servletToolInfo);
            } else if (servletToolInfo.getScope().equalsIgnoreCase("application")) {
                this.appTools.put(servletToolInfo.getKey(), servletToolInfo.getInstance(this.servletContext));
            } else {
                this.log("Unknown scope: " + servletToolInfo.getScope() + " " + servletToolInfo.getKey() + " will be request scoped.");
                this.requestToolInfo.add(servletToolInfo);
            }
        } else {
            this.requestToolInfo.add(toolInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ToolboxContext getToolboxContext(Object object) {
        Object object2;
        HttpSession httpSession;
        ViewContext viewContext = (ViewContext)object;
        HashMap hashMap = new HashMap(this.appTools);
        if (!this.sessionToolInfo.isEmpty() && (httpSession = viewContext.getRequest().getSession(this.createSession)) != null) {
            object2 = httpSession;
            synchronized (object2) {
                HashMap<String, Object> hashMap2 = (HashMap<String, Object>)httpSession.getAttribute(SESSION_TOOLS_KEY);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, Object>(this.sessionToolInfo.size());
                    Iterator iterator = this.sessionToolInfo.iterator();
                    while (iterator.hasNext()) {
                        ToolInfo toolInfo = (ToolInfo)iterator.next();
                        hashMap2.put(toolInfo.getKey(), toolInfo.getInstance(viewContext));
                    }
                    httpSession.setAttribute(SESSION_TOOLS_KEY, hashMap2);
                }
                hashMap.putAll(hashMap2);
            }
        }
        httpSession = this.requestToolInfo.iterator();
        while (httpSession.hasNext()) {
            object2 = (ToolInfo)httpSession.next();
            hashMap.put(object2.getKey(), object2.getInstance(viewContext));
        }
        return new ToolboxContext(hashMap);
    }
}

