/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.struts;

import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.util.MessageResources;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.tools.struts.StrutsUtils;
import org.apache.velocity.tools.view.context.ViewContext;
import org.apache.velocity.tools.view.tools.ViewTool;

public class MessageTool
implements ViewTool {
    protected MessageResources resources;
    protected Locale locale;

    public void init(Object object) {
        if (!(object instanceof ViewContext)) {
            throw new IllegalArgumentException("Tool can only be initialized with a ViewContext");
        }
        ViewContext viewContext = (ViewContext)object;
        HttpServletRequest httpServletRequest = viewContext.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(false);
        ServletContext servletContext = viewContext.getServletContext();
        this.resources = StrutsUtils.getMessageResources(servletContext);
        this.locale = StrutsUtils.getLocale(httpServletRequest, httpSession);
    }

    public String get(String string) {
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return null;
        }
        return this.resources.getMessage(this.locale, string);
    }

    public String get(String string, Object[] objectArray) {
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return null;
        }
        if (objectArray == null) {
            return this.resources.getMessage(this.locale, string);
        }
        return this.resources.getMessage(this.locale, string, objectArray);
    }

    public String get(String string, List list) {
        return this.get(string, list.toArray());
    }

    public boolean exists(String string) {
        if (this.resources == null) {
            Velocity.error((Object)"Message resources are not available.");
            return false;
        }
        return this.resources.isPresent(this.locale, string);
    }

    public Locale getLocale() {
        return this.locale;
    }
}

