/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.eelist.editorlistview.provider;

import jp.sourceforge.eelist.editorlistview.error.ErrorUtil;
import jp.sourceforge.eelist.editorlistview.model.TreeObject;
import jp.sourceforge.eelist.editorlistview.model.TreeParent;
import jp.sourceforge.eelist.editorlistview.provider.IEditorList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditorListContentProvider
implements ITreeContentProvider,
IEditorList {
    private TreeParent invisibleRoot = new TreeParent(null);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput == null || !(newInput instanceof IViewSite)) {
            return;
        }
        try {
            if (oldInput != null && oldInput instanceof IViewSite && newInput.equals(oldInput)) {
                this.invisibleRoot.removeChild(null);
            }
            this.createRootforProject();
            this.createData();
        }
        catch (CoreException e) {
            ErrorUtil.ShowErrorDlg(e);
        }
    }

    public void dispose() {
        if (this.invisibleRoot != null) {
            this.invisibleRoot = null;
        }
    }

    public Object[] getElements(Object parent) {
        return parent instanceof IViewSite ? this.getChildren(this.invisibleRoot) : this.getChildren(parent);
    }

    public Object[] getChildren(Object parentElement) {
        return parentElement instanceof TreeParent ? ((TreeParent)parentElement).getChildren() : new Object[]{};
    }

    public Object getParent(Object child) {
        return child instanceof TreeObject ? ((TreeObject)child).getParent() : null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof TreeParent ? ((TreeParent)element).hasChildren() : false;
    }

    public void add(Object object) throws CoreException {
        IResource resource = null;
        IEditorInput input = null;
        if (object instanceof IProject) {
            this.invisibleRoot.addChild(new TreeParent(object));
        } else if (object instanceof IEditorInput) {
            input = (IEditorInput)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)input.getAdapter((Class)clazz)) != null) {
                this.add(resource.getProject(), input);
            }
        } else {
            throw ErrorUtil.createCoreException(1, "\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public void add(IProject project, IEditorInput input) throws CoreException {
        TreeObject child = null;
        TreeParent parent = null;
        parent = (TreeParent)this.search(project);
        if (parent != null) {
            child = new TreeObject(input);
            parent.addChild(child);
        }
    }

    public void remove(Object object) throws CoreException {
        IResource resource = null;
        IEditorInput input = null;
        TreeParent parent = null;
        if (object instanceof IProject) {
            parent = (TreeParent)this.search(object);
            this.invisibleRoot.removeChild(parent);
        } else if (object instanceof IEditorInput) {
            input = (IEditorInput)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)input.getAdapter((Class)clazz)) != null) {
                this.remove(resource.getProject(), input);
            }
        } else {
            throw ErrorUtil.createCoreException(1, "\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
    }

    public void remove(IProject project, IEditorInput input) throws CoreException {
        TreeParent parent = null;
        TreeObject child = null;
        parent = (TreeParent)this.search(project);
        child = (TreeObject)this.search(input);
        if (parent != null && child != null) {
            parent.removeChild(child);
        }
    }

    public boolean isContain(Object object) {
        return this.search(object) != null;
    }

    public boolean isContain(IProject project, IEditorInput input) {
        TreeParent parent = null;
        parent = (TreeParent)this.search(project);
        return parent == null ? false : parent.isContain(input);
    }

    public Object search(Object object) {
        TreeObject child;
        block7: {
            IProject project;
            TreeObject[] parents;
            block8: {
                child = null;
                parents = null;
                project = null;
                parents = this.invisibleRoot.getChildren();
                if (!(object instanceof IEditorInput)) break block8;
                int i = 0;
                while (i < parents.length) {
                    child = ((TreeParent)parents[i]).getChild(object);
                    if (child == null) {
                        ++i;
                        continue;
                    }
                    break block7;
                }
                break block7;
            }
            if (!(object instanceof IProject)) break block7;
            int i = 0;
            while (i < parents.length) {
                TreeObject treeObject = parents[i];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object.equals(project = (IProject)treeObject.getAdapter(clazz))) {
                    child = parents[i];
                    break;
                }
                ++i;
            }
        }
        return child;
    }

    private void createRootforProject() {
        IWorkspaceRoot root = null;
        IProject[] projects = null;
        TreeParent child = null;
        root = ResourcesPlugin.getWorkspace().getRoot();
        projects = root.getProjects();
        int i = 0;
        while (i < projects.length) {
            child = new TreeParent(projects[i]);
            this.invisibleRoot.addChild(child);
            ++i;
        }
    }

    private void createData() throws CoreException {
        IWorkbench workbench = null;
        IWorkbenchWindow[] windows = null;
        IWorkbenchPage[] pages = null;
        IEditorReference[] references = null;
        IEditorInput input = null;
        TreeParent parent = null;
        workbench = PlatformUI.getWorkbench();
        windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                references = pages[j].getEditorReferences();
                int k = 0;
                while (k < references.length) {
                    input = references[k].getEditorInput();
                    parent = this.searchParent(input);
                    parent.addChild(new TreeObject(input));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private TreeParent searchParent(IEditorInput input) throws CoreException {
        TreeParent parent = null;
        TreeObject[] parents = null;
        IProject project = null;
        IResource resource = null;
        parents = this.invisibleRoot.getChildren();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resource = (IResource)input.getAdapter((Class)clazz);
        int i = 0;
        while (i < parents.length) {
            TreeObject treeObject = parents[i];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((project = (IProject)treeObject.getAdapter(clazz2)).equals((Object)resource.getProject())) {
                parent = (TreeParent)parents[i];
                break;
            }
            ++i;
        }
        if (parent == null) {
            throw ErrorUtil.createCoreException(1, "\u5185\u90e8\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
        }
        return parent;
    }
}

