package jp.sourceforge.projects.ee2e.core.editors;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.texteditor.AbstractTextEditor;

import jp.sourceforge.projects.ee2e.core.EE2EPlugin;
import org.eclipse.jface.text.BadLocationException;

/**
 * To change this generated comment edit the template variable "typecomment":
 * Window&gt;Preferences&gt;Java&gt;Templates.
 * To enable and disable the creation of type comments go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation.
 *
 * @author Toshikazu Ando [ ando@park.ruru.ne.jp ]
 */
public class EE2EUnTranslateRegion implements EE2EMenuBehavior {
	public EE2EUnTranslateRegion() {
	}
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setText()
     */
    public String getText() {
        return EE2EPlugin.getResourceString("action.untranslateR") + "(&;)";
    }

    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#setToolTip()
     */
    public String getToolTipText() {
        return EE2EPlugin.getResourceString("action.untranslateR.tooltip");
    }
    
    /**
     * @see jp.sourceforge.projects.ee2e.core.editors.EE2EMenuBehavior#doBehavior(AbstractTextEditor, IDocument, ITextSelection)
     */
	public void doBehavior(
		AbstractTextEditor editor,
		ITextSelection textSelection)
		throws BadLocationException {
        IDocument document = EE2EToolkit.get().getEditorToDocument(editor);
		String text = textSelection.getText();
		if ((textSelection.getLength() <= 0) && (text.equals(""))) {
			return;
		}
		String oldText = "";
		while (true) {
			int ltInt = text.indexOf(EE2ETranslateRegion.LEFT_AFTER);
			int gtInt = text.indexOf(EE2ETranslateRegion.RIGHT_AFTER);
            int ampInt = text.indexOf(EE2ETranslateRegion.AMP_AFTER);
            int doubleInt = text.indexOf(EE2ETranslateRegion.DOUBLE_AFTER);
			if ((ltInt < 0) && (gtInt < 0) && (ampInt < 0)) {
				break;
			}
			if (ltInt < 0) {
				ltInt = Integer.MAX_VALUE;
			}
			if (gtInt < 0) {
				gtInt = Integer.MAX_VALUE;
			}
			if (ampInt < 0) {
				ampInt = Integer.MAX_VALUE;
			}
            if (doubleInt < 0) {
                doubleInt = Integer.MAX_VALUE;
            }
			String after = EE2ETranslateRegion.LEFT_AFTER;
			String result = EE2ETranslateRegion.LEFT_BEFOR;
			int min = ltInt;
			if (gtInt < min) {
				min = gtInt;
				after = EE2ETranslateRegion.RIGHT_AFTER;
				result = EE2ETranslateRegion.RIGHT_BEFOR;
			}
			if (ampInt < min) {
				min = ampInt;
				after = EE2ETranslateRegion.AMP_AFTER;
				result = EE2ETranslateRegion.AMP_BEFOR;
			}
            if (doubleInt < min) {
                min = doubleInt;
                after = EE2ETranslateRegion.DOUBLE_AFTER;
                result = EE2ETranslateRegion.DOUBLE_BEFOR;
            }
			oldText += text.substring(0, min);
			oldText += result;
			text = text.substring(min + after.length());
		}
		text = oldText + text;
		document.replace(
			textSelection.getOffset(),
			textSelection.getLength(),
			text);
	}
}
