package jp.ac.takushoku_u.cs;
import java.util.Stack;

/**
* TaskSequenceMatrix饹Ϸ̤Ƶ뤿Υ饹Ǥ
* ̤ϥޥȥꥯ֤졢ƹԤ줾1Ĥη̤ȤʤäƤޤ
* Τᡢ֤ޥȥꥯ礭ϡ̡߷Ԥܿ Ȥʤޤ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.TaskSequence
*/
/*
* ǽ 2005ǯ0208
*/
public final class TaskSequenceMatrix{
	
/**
* 󥹥ȥ饯
*/
	private TaskSequenceMatrix(){
	}
	
/**
* ̤Ƶ᤿ޥȥꥯ֤ޤ
* ޥȥꥯȤܥޥȥꥯֹ(󲽤Ԥֹ)
* ޥȥꥯֹξۤԤäޤ
* @param adjacencyMatrix 󲽤Ԥܥޥȥꥯ
* @param alpha ꤹ륢ե
* @param beta ꤹ١
* @return ̤ݻޥȥꥯ
* @exception NotSquareMatrixException ܥޥȥꥯǤϤʤ
* @exception SetValueOutOfBoundsException եȥ١ͤǤ
*/
	public static final ArithmeticMatrix getTaskMatrix(ArithmeticMatrix adjacencyMatrix, double alpha, double beta){
		TaskSequence ts = new TaskSequence(adjacencyMatrix);
		ArithmeticMatrix mat = new ArithmeticMatrix();
		mat.matrixCopy(getTaskMatrix(adjacencyMatrix, alpha, beta, ts.getTaskSequence(alpha, beta),
			ts.isDummy() ,ts.getDivergenceMatrix()));
		
		//0ʤԤӽ
		boolean isIn[] = new boolean[mat.getRowLength()];
		for(int i = 0; i < mat.getRowLength(); i++){
			int count = 0;
			for(int j = 0; j < mat.getColLength(); j++){
				if(mat.getCell(i, j) == 0){
					count++;
				}
			}
			if(count > 1){
				isIn[i] = false;
			}
			
			//0Ǥʤ
			else{
				isIn[i] = true;
			}
		}
		
		//0ιԤ
		int number = -1;
		int counter = 0;
		for(int i = 0; i < isIn.length; i++){
			if(isIn[i]){
				number++;
				counter++;
				if(number != i){
					for(int j = 0; j < mat.getColLength(); j++){
						mat.setCell(number, j, mat.getCell(i,j));
						mat.setCell(i, j, 0);
					}
					isIn[i] = false;
					i = number + 1;
				}
			}
		}
		
		//ꥵ
		mat.reSizeMatrix(counter, mat.getColLength());
		mat.setRowNameNumber();
		mat.setColNameNumber();
		
		return mat;
	}
	
	
/**
* ̤Ƶ᤿ޥȥꥯStringMatrix֤ޤ
* ޥȥꥯȤܥޥȥꥯǻꤷ̾(󲽤Ԥ̾)
* ޥȥꥯֹξԤäޤ
* @param adjacencyMatrix 󲽤Ԥܥޥȥꥯ
* @param alpha ꤹ륢ե
* @param beta ꤹ١
* @return ̤ݻޥȥꥯ
* @exception NotSquareMatrixException ܥޥȥꥯǤϤʤ
* @exception SetValueOutOfBoundsException եȥ١ͤǤ
*/
	public static final StringMatrix getTaskStringMatrix(ArithmeticMatrix adjacencyMatrix, double alpha, double beta){
		ArithmeticMatrix mat = new ArithmeticMatrix();
		mat.matrixCopy(getTaskMatrix(adjacencyMatrix, alpha, beta));
		StringMatrix returnMatrix = new StringMatrix(mat.getRowLength(), mat.getColLength());
		
		for(int i = 0; i < mat.getRowLength(); i++){
			for(int j = 0; j < mat.getColLength(); j++){
				returnMatrix.setCell(i, j, adjacencyMatrix.getColName((int)mat.getCell(i, j)));
			}
		}
		
		return returnMatrix;
	}
	
/**
* ̤Ƶޤ
* @param matrix 󲽤Ԥޥȥꥯ
* @param alpha ꤹ륢ե
* @param beta ꤹ١
* @param seq 󲽤Ԥä
* @param du Ԥݤ˥ߡդɤ
* @param trMatrix ʬݻޥȥꥯ
* @return ̤Υޥȥꥯ
*/
		private static final ArithmeticMatrix getTaskMatrix(ArithmeticMatrix matrix, double alpha, double beta,
			Sequence seq, boolean du, BooleanMatrix trMatrix){
			
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(1, matrix.getColLength());
			Stack st = new Stack();
				
			//ͥ
			int[] ar = new int[0];
				
			//켡¸
			int[] tmp = new int[matrix.getRowLength() * matrix.getRowLength()];
				
			//ʣǤӽͥ
			int[] tar = new int[0];
			TaskSequence tsq = new TaskSequence(matrix);
			
			//ޥȥꥯ
			for(int i = 0; i < seq.getLength(); i++){
				returnMatrix.setCell(0, i, seq.getItem(i));
			}
			
			for(int i = 0; i < trMatrix.getRowLength(); i++){
				for(int j = 0; j < trMatrix.getColLength(); j++){
					if(trMatrix.getCell(i, j)){
						if(du){
							st.push(new Edge(i-1, j-1));
						}
						else{
							st.push(new Edge(i, j));
						}
					}
				}
			}
			
			while(!st.empty()){
				
				//åͤФ
				Edge ed = new Edge();
				ed = (Edge)st.pop();
				
				//ͥ
				int element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element + 2];
				System.arraycopy(tmp,0,ar,0,element);
				
				//ͥ˥åͤ
				ar[element] = ed.getEnd();
				ar[element+1] = ed.getBegin();
				
				//ʣǤӽ
				int k = 0;
				for(int i=0; i < ar.length; i++){
					boolean flag = true;
					for(int j = i+1; j < ar.length; j++){
						if(ar[i] == ar[j]){
							flag = false;
						}
					}
					if(flag){
						tmp[k] = ar[i];
						k++;
					}
				}
				
				//󲽤Ԥݤͥ
				tar = new int[k];
				System.arraycopy(tmp,0,tar,0,k);
				
				//󲽤Ԥ(Ƶ)
				tsq.setPriorityOrder(tar);
				ArithmeticMatrix mat = new ArithmeticMatrix();
				mat.matrixCopy(getTaskMatrix(matrix, alpha, beta, 
					tsq.getTaskSequence(alpha, beta), tsq.isDummy(), tsq.getDivergenceMatrix(), ar));
				
				//̤
				int size = returnMatrix.getRowLength();
				int tsize = size;
				returnMatrix.reSizeMatrix(size + mat.getRowLength(), returnMatrix.getColLength());
				for(int i = 0; i < mat.getRowLength();i++){
					boolean flagB = true;
					for(int ia = 0; ia < size && flagB; ia++){
						boolean flagC = true;
						for(int ib = 0; ib < returnMatrix.getColLength() && flagC; ib++){
							if(returnMatrix.getCell(ia,ib) != mat.getCell(i,ib)){
								flagC = false;
							}
						}
						
						//flagCtrueʤƱ󤬤Ǥˤ
						if(flagC){
							flagB = false;
						}
					}
					
					//Ʊ̤ӽ
					if(flagB){
						for(int j = 0; j < mat.getColLength(); j++){
							returnMatrix.setCell(size + i, j, mat.getCell(i,j));
						}
						tsize++;
					}
				}
				
				returnMatrix.reSizeMatrix(tsize+1, returnMatrix.getColLength());
				
				//ͥ󤫤2Ǥ
				element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element - 2];
				System.arraycopy(tmp,0,ar,0,element - 2);
				
			}
			return returnMatrix;
			
		}
	
/**
* ̤Ƶޤ
* @param matrix 󲽤Ԥޥȥꥯ
* @param alpha ꤹ륢ե
* @param beta ꤹ١
* @param seq 󲽤Ԥä
* @param du Ԥݤ˥ߡդɤ
* @param trMatrix ʬݻޥȥꥯ
* @param ar ͥݻ
* @return ̤Υޥȥꥯ
*/
		private static final ArithmeticMatrix getTaskMatrix(ArithmeticMatrix matrix, double alpha, double beta,
			Sequence seq, boolean du, BooleanMatrix trMatrix, int[] ar){
			
			
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(1, matrix.getColLength());
			Stack st = new Stack();
				
			//켡¸
			int[] tmp = new int[matrix.getRowLength() * matrix.getRowLength()];
			int[] tar = new int[0];
			TaskSequence tsq = new TaskSequence(matrix);
			
			//ޥȥꥯ
			for(int i = 0; i < seq.getLength(); i++){
				returnMatrix.setCell(0, i, seq.getItem(i));
			}
			
			for(int i = 0; i < trMatrix.getRowLength(); i++){
				for(int j = 0; j < trMatrix.getColLength(); j++){
					if(trMatrix.getCell(i, j)){
						boolean flagA = true;
						
						//ͥˤǤϽ
						for(int n = 0; n < ar.length; n = n + 2){
							if(ar[n] == j && ar[n+1] == i && !du){
								flagA = false;
							}
							else if(ar[n] == j-1 && ar[n+1] == i-1 && du){
								flagA = false;
							}
						}
						if(flagA){
							if(du){
								st.push(new Edge(i-1, j-1));
							}
							else{
								st.push(new Edge(i, j));
							}
						}
					}
				}
			}
			
			while(!st.empty()){
				
				//åͤФ
				Edge ed = new Edge();
				ed = (Edge)st.pop();
				
				//ͥ
				int element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element + 2];
				System.arraycopy(tmp,0,ar,0,element);
				
				//ͥ˥åͤ
				ar[element] = ed.getEnd();
				ar[element+1] = ed.getBegin();
				
				//ʣǤӽ
				int k = 0;
				for(int i=0; i < ar.length; i++){
					boolean flag = true;
					for(int j = i+1; j < ar.length; j++){
						if(ar[i] == ar[j]){
							flag = false;
						}
					}
					if(flag){
						tmp[k] = ar[i];
						k++;
					}
				}
				
				//󲽤Ԥݤͥ
				tar = new int[k];
				System.arraycopy(tmp,0,tar,0,k);
				
				//󲽤Ԥ(Ƶ)
				tsq.setPriorityOrder(tar);
				ArithmeticMatrix mat = new ArithmeticMatrix();
				mat.matrixCopy(getTaskMatrix(matrix, alpha, beta, 
					tsq.getTaskSequence(alpha, beta), tsq.isDummy(), tsq.getDivergenceMatrix(), ar));
				
				
				//̤
				int size = returnMatrix.getRowLength();
				int tsize = size;
				
				returnMatrix.reSizeMatrix(size + mat.getRowLength(), returnMatrix.getColLength());
				
				for(int i = 0; i < mat.getRowLength();i++){
					
					boolean flagB = true;
					
					for(int ia = 0; ia < size && flagB; ia++){
						boolean flagC = true;
						for(int ib = 0; ib < returnMatrix.getColLength() && flagC; ib++){
							if(returnMatrix.getCell(ia,ib) != mat.getCell(i,ib)){
								flagC = false;
							}
						}
						
						//flagCtrueʤƱ󤬤Ǥˤ
						if(flagC){
							flagB = false;
						}
					}
					
					//Ʊ̤ӽ
					if(flagB){
						for(int j = 0; j < mat.getColLength(); j++){
							returnMatrix.setCell(size + i, j, mat.getCell(i,j));
						}
						tsize++;
					}
				}
				
				returnMatrix.reSizeMatrix(tsize+1, returnMatrix.getColLength());
				
				//ͥ󤫤2Ǥ
				element = ar.length;
				System.arraycopy(ar,0,tmp,0,element);
				ar = new int[element - 2];
				System.arraycopy(tmp,0,ar,0,element - 2);
				
			}
			return returnMatrix;
			
		}
}