package jp.ac.takushoku_u.cs;

/**
* TaskSequence饹ϳؽˡԤΥ饹Ǥ<BR>
* 󲽤Ԥ˲۹ܤɬפǤ깽¤ξǤäƤ⡢
* ưŪ˲۹ܤͿ󲽤ԤȤǤޤ
* ۹ܤ0ܤ0ܤͿ졢̾̾Ϥ`Dummy'Ȥʤޤ
* @version 1.1.2
* @author  ͵(Kasajima Hiroshi)
*/
/*
* ǽ 2005ǯ0208
*/
public class TaskSequence{
	
/**
* 󲽤Ԥܥޥȥꥯ(۹ܤʤ)
*/
	private ArithmeticMatrix baseMatrix;
/**
* 󲽤Ԥܥޥȥꥯ(۹)
*/	
	private ArithmeticMatrix matrix;
	
/**
* ۹ܤͿѿ
*/
	private boolean giveDummy = false;
	
/**
* ʬ뤳Ȥ򼨤Υޥȥꥯ
*/
	private BooleanMatrix divergenceMatrix;
	
/**
* ̤ͥդޤ
*/
	private int[] priorityOrder;
	
/**
* ̤ͥդɤ򼨤
*/
	private boolean isPriorityOrder = false;
	
/**
* եν
*/
	private static final double TASK_SEQUENCE_ALPHA = 0.5;
	
/**
* ١ν
*/
	private static final double TASK_SEQUENCE_BETA = 0.5;
	
/**
* ͭޤ뤳Ȥ򼨤
*/
	private static final double TASK_SEQUENCE_TRUE = 1.0;
	
/**
* ͭޤʤȤ򼨤
*/
	private static final double TASK_SEQUENCE_FALSE = 0.0;
	
/**
* ޥȥꥯν
*/
	private static final int TASK_SEQUENCE_MATRIX_SIZE = 5;
	
/**
* ǥեȤꤵƤͤǷ󲽤Ԥܥޥȥꥯꤷޤ
*/
	public TaskSequence(){
		baseMatrix = new ArithmeticMatrix(TASK_SEQUENCE_MATRIX_SIZE, TASK_SEQUENCE_MATRIX_SIZE);
		matrix = new ArithmeticMatrix(TASK_SEQUENCE_MATRIX_SIZE, TASK_SEQUENCE_MATRIX_SIZE);
	}
	
/**
* 󲽤Ԥܥޥȥꥯꤷޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ܥޥȥꥯǤϤʤ
*/
	public TaskSequence(ArithmeticMatrix adjacencyMatrix){
		baseMatrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength());
		matrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength());
		setMatrix(adjacencyMatrix);
	}
	
	
/**
* ܥޥȥꥯ֤ޤ
* @return ܥޥȥꥯ
* @see #getDummyMatrix()
*/
	public ArithmeticMatrix getMatrix(){
		return baseMatrix;
	}
	
/**
* ۹ܹߤܥޥȥꥯ֤ޤ
* ۹ܤͿʤȤ褤ܥޥȥꥯξgetMatrix()Ʊޥȥꥯ֤ޤ
* @return ۹ܤͿܥޥȥꥯ
* @see #getMatrix()
*/
	public ArithmeticMatrix getDummyMatrix(){
		return matrix;
	}
	
/**
* ãޥȥꥯ֤ޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ãޥȥꥯ
*/
	public ArithmeticMatrix getReachMatrix(){
		return getReachMatrix(matrix);
	}
	
/**
* ܥޥȥꥯãޥȥꥯ֤ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @return ãޥȥꥯ
*/
	private ArithmeticMatrix getReachMatrix(ArithmeticMatrix adjacencyMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(),
			adjacencyMatrix.getColLength(), adjacencyMatrix.getRowNameArray(), adjacencyMatrix.getColNameArray());
		return adjacencyMatrix.getReachMatrix();
	}
	
/**
* ޥȥꥯ֤ޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ޥȥꥯ
*/
	public ArithmeticMatrix getFMatrix(){
		ArithmeticMatrix reachMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		reachMatrix.matrixCopy(getReachMatrix(matrix));
		
		return getFMatrix(reachMatrix);
	}
	
/**
* ãޥȥꥯޥȥꥯ֤ޤ
* @param reachMatrix ãޥȥꥯ
* @return ޥȥꥯ
*/
	private ArithmeticMatrix getFMatrix(ArithmeticMatrix reachMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		ArithmeticMatrix TMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		
		TMatrix.matrixCopy(reachMatrix.getTransposedMatrix());
		returnMatrix.matrixCopy(TMatrix.getMultiplyMatrix(reachMatrix));
		return returnMatrix;
	}
	
/**
* ɸޥȥꥯ֤ޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ɸޥȥꥯ
*/
	public ArithmeticMatrix getGMatrix(){
		ArithmeticMatrix reachMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		reachMatrix.matrixCopy(getReachMatrix(matrix));
		
		return getGMatrix(reachMatrix);
	}
	
/**
* ãޥȥꥯɸޥȥꥯ֤ޤ
* @param reachMatrix ãޥȥꥯ
* @return ɸޥȥꥯ
*/
	private ArithmeticMatrix getGMatrix(ArithmeticMatrix reachMatrix){
		ArithmeticMatrix returnMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		ArithmeticMatrix TMatrix = new ArithmeticMatrix(reachMatrix.getRowLength(), reachMatrix.getColLength(),
			reachMatrix.getRowNameArray(), reachMatrix.getColNameArray());
		
		TMatrix.matrixCopy(reachMatrix.getTransposedMatrix());
		returnMatrix.matrixCopy(reachMatrix.getMultiplyMatrix(TMatrix));
		return returnMatrix;
	}
	
/**
* 2ܴ֤ι֤ޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܤθ֤ͤޤ
* ۹ܤꤹɬפΤܥޥȥꥯξ硢
* ܥޥȥꥯιֹvivjֹ椬פʤդɬפǤ
* @param vi vi
* @param vj vj
* @return 
* @exception NotElementException ꤵ줿¸ߤʤ
*/

	public double getF(int vi, int vj){
		
		ArithmeticMatrix mat = new ArithmeticMatrix();
		mat.matrixCopy(getFMatrix());
		return mat.getCell(vi, vj);		//¸ߤʤ㳰
	}
	
/**
* 2ܴ֤ιɸ֤ޤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܤθ֤ͤޤ
* ۹ܤꤹɬפΤܥޥȥꥯξ硢
* ܥޥȥꥯιֹvivjֹ椬פʤդɬפǤ
* @param vi vi
* @param vj vj
* @return ɸ
* @exception NotElementException ꤵ줿¸ߤʤ
*/
	public double getG(int vi, int vj){
		
		ArithmeticMatrix mat = new ArithmeticMatrix();
		mat.matrixCopy(getGMatrix());
		return mat.getCell(vi, vj);		//¸ߤʤ㳰
	}
	
/**
* ҡޥȥꥯ֤ޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @return ҡޥȥꥯ
*/
	public ArithmeticMatrix getCoherenceMatrix(){
		ArithmeticMatrix FMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		ArithmeticMatrix GMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		FMatrix.matrixCopy(getFMatrix());
		GMatrix.matrixCopy(getGMatrix());
		return getCoherenceMatrix(FMatrix, GMatrix);
	}
	
/**
* ҡޥȥꥯ֤ޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* ۹ܤɬפܥޥȥꥯꤷ硢۹ܹߤΥޥȥꥯ֤ޤ
* @param alpha ե
* @param beta ١
* @return ҡޥȥꥯ
*/
	public ArithmeticMatrix getCoherenceMatrix(double alpha, double beta){
		ArithmeticMatrix FMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		ArithmeticMatrix GMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		FMatrix.matrixCopy(getFMatrix());
		GMatrix.matrixCopy(getGMatrix());
		return getCoherenceMatrix(FMatrix, GMatrix, alpha, beta);
	}
	
/**
* ޥȥꥯȹɸޥȥꥯ饳ҡޥȥꥯޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* @param FMatrix ޥȥꥯ
* @param GMatrix ɸޥȥꥯ
* @return ҡޥȥꥯ
* 
*/
	private ArithmeticMatrix getCoherenceMatrix(ArithmeticMatrix FMatrix, ArithmeticMatrix GMatrix){
		return FMatrix.getAddMatrix(GMatrix);
	}
	
/**
* ޥȥꥯȹɸޥȥꥯ饳ҡޥȥꥯޤ
* ֤륳ҡޥȥꥯϡޥȥꥯ + ɸޥȥꥯǤ
* @param FMatrix ޥȥꥯ
* @param GMatrix ɸޥȥꥯ
* @param alpha ե
* @param beta ١
* @return ҡޥȥꥯ
* 
*/
	private ArithmeticMatrix getCoherenceMatrix(ArithmeticMatrix FMatrix, ArithmeticMatrix GMatrix, double alpha, double beta){
		ArithmeticMatrix Fm = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		ArithmeticMatrix Gm = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
			matrix.getRowNameArray(), matrix.getColNameArray());
		Fm.matrixCopy(FMatrix.getTimesMatrix(alpha));
		Gm.matrixCopy(GMatrix.getTimesMatrix(beta));
		return Fm.getAddMatrix(Gm);
	}
	
/**
* 󲽤줿ֹ֤ޤ
* եȥ١ͤϥǥեͤȤʤޤ
* @return 󲽤줿Ǽ
*/
	public int[] getTaskSequenceArray(){
		return getTaskSequenceArray(TASK_SEQUENCE_ALPHA, TASK_SEQUENCE_BETA);
	}
	
/**
* 󲽤줿ֹ֤ޤ
* ȤϷ󲽤줿ܥޥȥꥯιֹǤ
* @param alpha ե
* @param beta ١
* @return 󲽤줿Ǽ
* @exception SetValueOutOfBoundsException եȥ١ͤǤ
*/
	public int[] getTaskSequenceArray(double alpha, double beta){
		
		//եȥ١Ŭɤ
		if(isNormalIndex(alpha, beta)){
			
			//ãޥȥꥯ
			ArithmeticMatrix reachMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			reachMatrix.matrixCopy(getReachMatrix(matrix));
			
			//ҡޥȥꥯ
			ArithmeticMatrix CMatrix = new ArithmeticMatrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			CMatrix.matrixCopy(getCoherenceMatrix(alpha, beta));
			
			//ʬΥޥȥꥯ
			divergenceMatrix = new BooleanMatrix(matrix.getRowLength(), matrix.getColLength(),
				matrix.getRowNameArray(), matrix.getColNameArray());
			divergenceMatrix.clearMatrix();
			
			//̤֤
			int[] returnArray;
			
			//ǽܤä
				boolean[] el = new boolean[reachMatrix.getRowLength()];
			
			//۹ܤꤷ
			if(isDummy()){
				returnArray = new int[reachMatrix.getRowLength()-1];
				
				//
				int item = 0;
				
				//ܤ򤹤
				System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
				for(int i = 0; i < reachMatrix.getRowLength() -1; i++){
					if(el[i]){
						item = i;
					}
				}
				
				//¤
				for(int i = 0; i < reachMatrix.getColLength(); i++){
					reachMatrix.setCell(item, i, 0);
				}
				
				//󲽤򤹤
				for(int i = 0;i < reachMatrix.getRowLength()-1; i++){
					
					//򤵤Ƥܤ鼡򤹤ܤõ
					System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
					item = getItemNumber(item, el, CMatrix);
					returnArray[i] = item -1;
					for(int j = 0; j < reachMatrix.getColLength(); j++){
						reachMatrix.setCell(item, j, 0);
					}
				}
			}
			
			//۹ܤ̵
			else{
				returnArray = new int[reachMatrix.getRowLength()];
				
				//
				int item = 0;
				
				//ܤ򤹤
				System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
				for(int i = 0; i < reachMatrix.getRowLength(); i++){
					if(el[i]){
						item = i;
					}
				}
				returnArray[0] = item;
				for(int i = 0; i < reachMatrix.getColLength(); i++){
					reachMatrix.setCell(item, i, 0);
				}
				
				//󲽤򤹤
				for(int i = 1;i < reachMatrix.getRowLength(); i++){
					
					//򤵤Ƥܤ鼡򤹤ܤõ
					System.arraycopy(getReachElement(reachMatrix), 0, el, 0, reachMatrix.getRowLength());
					item = getItemNumber(item, el, CMatrix);
					returnArray[i] = item;
					for(int j = 0; j < reachMatrix.getColLength(); j++){
						reachMatrix.setCell(item, j, 0);
					}
				}
			}
			return returnArray;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("alpha(" + alpha + "),beta("+ beta +")");
		}
	}
	
/**
* 󲽤줿ֹSequence֤ޤ
* եȥ١ͤϥǥեͤˤʤޤ
* @return 󲽤줿Ǽ
*/
	public Sequence getTaskSequence(){
		return getTaskSequence(TASK_SEQUENCE_ALPHA, TASK_SEQUENCE_BETA);
	}
	
/**
* 󲽤줿ֹSequence֤ޤ
* @param alpha ե
* @param beta ١
* @return 󲽤줿Ǽ
* @exception SetValueOutOfBoundsException եȥ١ͤǤ
*/
	public Sequence getTaskSequence(double alpha, double beta){
		
		//եȥ١Ŭɤ
		if(isNormalIndex(alpha, beta)){
			Sequence seq = new Sequence(getTaskSequenceArray(alpha, beta));
			for(int i = 0; i < seq.getLength(); i++){
				seq.setItemName(i, baseMatrix.getRowName(seq.getItem(i)));
			}
			return seq;
		}
		else{		//顼ξ
			throw new SetValueOutOfBoundsException("alpha(" + alpha + "),beta("+ beta +")");
		}
	}
	
/**
* ¾ǤزãǤ뤬¾Ǥ餽ǤؤϲãǤϤʤǤãޥȥꥯõޤ
* ʤǽܤõޤ
* ̤ϥǿboolean֤ޤ
* @param reachMatrix ãޥȥꥯ
* @return ̤
*/
	public boolean[] getReachElement(ArithmeticMatrix reachMatrix){
		boolean[] returnArray = new boolean[reachMatrix.getRowLength()];
		for(int i = 0; i < reachMatrix.getRowLength(); i++){
			int count = 0;
			for(int j = 0; j < reachMatrix.getColLength(); j++){
				if(reachMatrix.getCell(j,i) == TASK_SEQUENCE_TRUE){
					count++;
				}
			}
			
			if(count == 1){
				returnArray[i] = true;
			}
			else{
				returnArray[i] = false;
			}
		}
		
		return returnArray;
	}
	
/**
* ǽܤä󤫤򤵤ܤõޤ
* @param item 򤹤
* @param choiceArray ǽܤä
* @param coherenceMatrix ҡޥȥꥯ
* @return 򤵤
*/
	private int getItemNumber(int item, boolean[] choiceArray, ArithmeticMatrix coherenceMatrix){
		int itemNumber = 0;
		double val = Double.NEGATIVE_INFINITY;
		for(int i = 0; i < choiceArray.length; i++){
			if(choiceArray[i] && coherenceMatrix.getCell(item, i) > val){
				val = coherenceMatrix.getCell(item, i);
				itemNumber = i;
			}
		}
		
		//Ʊ򤬲ǽǤäܤõ
		for(int i = 0; i < choiceArray.length; i++){
			if(i!= itemNumber && choiceArray[i] && coherenceMatrix.getCell(item, i) == val){
				divergenceMatrix.setCell(itemNumber, i, true);
			}
		}
		
		//ͥؤ
		if(isPriority()){
			for(int i = 0; i < priorityOrder.length; i++){
				int hikaku = itemNumber;
				if(isDummy()){
					hikaku = hikaku -1;
				}
				
				//ͥˤ뤫
				if(priorityOrder[i] == hikaku){
					
					for(int j = 0; j < i; j++){
						int hikakuA = priorityOrder[j];
						if(isDummy()){
							hikakuA++;
						}
						
						//ܤͥιܤ뤫
						if(divergenceMatrix.getCell(itemNumber, hikakuA)){
							for(int k = 0; k < divergenceMatrix.getRowLength(); k++){
								divergenceMatrix.setCell(itemNumber, k, false);
							}
							itemNumber = hikakuA;
							for(int k = 0; k < divergenceMatrix.getRowLength(); k++){
								if(itemNumber != k && choiceArray[k] 
								&& coherenceMatrix.getCell(item, k) == val){
										divergenceMatrix.setCell(itemNumber, k, true);
								}
							}
							i = priorityOrder.length;
							j = i;
						}
					}
				}
			}
		}
		
		return itemNumber;
	}
	
/**
* 󲽤Ԥäݤʬäɤ֤ޤ
* ΥޥȥꥯϡgetTaskSequence⤷getTaskSequenceArray¹ԤΤ
* ޤ
* ޥȥꥯˤ(i, j)trueΤȤi򤹤ݤj򤹤뤳ȤǤȤ򼨤ޤ
* @return ʬΥޥȥꥯ
* @see #getTaskSequenceArray()
* @see #getTaskSequenceArray(double alpha, double beta)
* @see #getTaskSequence()
* @see #getTaskSequence(double alpha, double beta)
*/
	public BooleanMatrix getDivergenceMatrix(){
		return divergenceMatrix;
	}
	
/**
* 󲽤Ԥݤˤɤݤˤɤ뤫Ȥ̤ͥĤޤ
* ͥդƱΤ˳Ǽޤ
* ͥ褷ܤֹۤξ˳Ǽޤ
* ꤷȡꤷͭˤʤޤ
* @param order ͥǼ
*/
	public void setPriorityOrder(int[] order){
		priorityOrder = new int[order.length];
		System.arraycopy(order, 0, priorityOrder, 0, order.length);
		setIsPriority(true);
	}
	
/**
* ͥդѤ뤫ޤ
* @param priority ͥѤƷԤtrueѤʤǷԤfalseȤޤ
*/
	public void setIsPriority(boolean priority){
		isPriorityOrder = priority;
	}
	
/**
* ͥդѤ뤫֤ޤ
* @return ͥԤtrue
*/
	public boolean isPriority(){
		return isPriorityOrder;
	}
	
/**
* եͤŬɤåޤ
* @param alpha ե
* @return ͤŬǤtrue
*/
	public boolean isNormalAlpha(double alpha){
		return (0.0 <= Math.abs(alpha)) && (Math.abs(alpha) <= 1.0);
	}
	
/**
* ١ͤŬɤåޤ
* @param beta ١
* @return ͤŬǤtrue
*/
	public boolean isNormalBeta(double beta){
		return (0.0 <= Math.abs(beta)) && (Math.abs(beta) <= 1.0);
	}
	
/**
* եȥ١ͤŬɤåޤ
* @param alpha ե
* @param beta ١
* @return ͤŬǤtrue
*/
	public boolean isNormalIndex(double alpha, double beta){
		boolean condition = (Math.abs(alpha) + Math.abs(beta) == 1.0);
		return condition && isNormalAlpha(alpha) && isNormalBeta(beta);
	}
	
/**
* ۹ܤɬפɤåޤ
* @param adjacencyMatrix Ĵ٤ܥޥȥꥯ
* @return ۹ܤɬפǤtrue
*/
	private boolean needDummy(ArithmeticMatrix adjacencyMatrix){
		ArithmeticMatrix RMatrix = new ArithmeticMatrix(adjacencyMatrix.getRowLength(), adjacencyMatrix.getColLength(),
			adjacencyMatrix.getRowNameArray(), adjacencyMatrix.getColNameArray());
		RMatrix.matrixCopy(adjacencyMatrix.getReachMatrix());
		
		boolean[] el = new boolean[RMatrix.getRowLength()];
		System.arraycopy(getReachElement(RMatrix), 0, el, 0, RMatrix.getRowLength());
		int count = 0;
		for(int i = 0; i < el.length; i++){
			if(el[i]){
				count++;
			}
		}
		
		//ܤ1Ķ
		return count > 1;
	}
	
/**
* ܥޥȥꥯꤷޤ
* @param m ꤹܥޥȥꥯ
* @exception NotSquareMatrixException ܥޥȥꥯǤϤʤ
*/
	public void setMatrix(ArithmeticMatrix m){
		if(m.isSquare()){
		baseMatrix.matrixCopy(m);
		setDummy();
		}
		else{
			throw new NotSquareMatrixException();
		}
	}
	
/**
* ۹ܤꤷޤ
*/
	private void setDummy(){
		matrix.matrixCopy(baseMatrix);
		if(needDummy(baseMatrix)){
			giveDummy = true;
			matrix.reSizeMatrix(baseMatrix.getRowLength()+1, baseMatrix.getColLength()+1);
			matrix.matrixMove(0, 0, 1, 1, baseMatrix.getRowLength(), baseMatrix.getColLength());
			matrix.rowNameMove(0, 1, baseMatrix.getRowLength());
			matrix.colNameMove(0, 1, baseMatrix.getColLength());
			matrix.setRowName(0, "Dummy");
			matrix.setColName(0, "Dummy");
			
			ArithmeticMatrix RMatrix = new ArithmeticMatrix(baseMatrix.getRowLength(), baseMatrix.getColLength(),
				baseMatrix.getRowNameArray(), baseMatrix.getColNameArray());
			RMatrix.matrixCopy(baseMatrix.getReachMatrix());
			
			for(int i = 0; i < matrix.getColLength(); i++){
				matrix.setCell(i, 0, TASK_SEQUENCE_FALSE);
			}
			
			boolean[] el = new boolean[RMatrix.getRowLength()];
			System.arraycopy(getReachElement(RMatrix), 0, el, 0, RMatrix.getRowLength());
			for(int i = 1; i < el.length+1; i++){
				if(el[i-1]){
					matrix.setCell(0, i, TASK_SEQUENCE_TRUE);
				}
				else{
					matrix.setCell(0, i, TASK_SEQUENCE_FALSE);
				}
			}
		}
		else{
			giveDummy = false;
		}
	}
	
/**
* ۹ܤꤷ֤ޤ
* @return ۹ܤꤷtrue
*/
	public boolean isDummy(){
		return giveDummy;
	}
	
/**
* ͤޤ
* ֤ͤϺɸǤ
* @return 
*/
	private int getRegular(){
		ArithmeticMatrix reachMatrix = new ArithmeticMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		double max = 0.0;
		int maxIndex = 0;
		double count = 0.0;
		for(int i = 0; i < matrix.getColLength(); i++){
			count = reachMatrix.getColSum(i);
			if(count > max){
				maxIndex = i;
				max = count;
			}
		}
		return (int)count;
	}
}