package jp.ac.takushoku_u.cs;

/**
* StringMatrix饹ǤʸǤˤĥޥȥꥯ򰷤ޤ
* ˽ϤΤ˰ޤ
* @version 1.1.1
* @author  ͵(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.ArithmeticMatrix
* @see jp.ac.takushoku_u.cs.BooleanMatrix
*/
/*
* ǽ 2004ǯ1209
*/
public class StringMatrix extends Matrix{

/**
* ޥȥꥯ򥯥ꥢȤ
*/
	private static final String MATRIX_CLEAR_VALUE = "";

/**
* Ƚ
*/
	private static final String MATRIX_VALUE_FALSE = "";


/**
* ꤵƤ륵Υǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿2falseǽޤ
* ̾̾Ϲֹֹꤵޤ
*/
	public StringMatrix(){
		super();
		clearMatrix();
	}

/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿2falseǽޤ
* ̾̾Ϲֹֹꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public StringMatrix(int rowSize, int colSize){
		super(rowSize, colSize);
		clearMatrix();
	}
	
/**
* ꤵ줿ԥ󥵥򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* 줿2falseǽޤ
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param nameNumber ̾̾γֹ
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public StringMatrix(int rowSize, int colSize, int nameNumber){
		super(rowSize, colSize, nameNumber);
		clearMatrix();
	}
	
/**
* ꤵ줿ԥ󥵥̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* 줿2falseǽޤ
* @param rowSize ꤹԥ
* @param colSize ꤹ󥵥
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
* @exception DisagreementArraySizeException ޥȥꥯλꤷȹ̾̾Ѥȥۤʤ
* @exception NullPointerException  rowName ޤ colName  null ξ
*/
	public StringMatrix(int rowSize, int colSize, String[] rowName, String[] colName){
		super(rowSize, colSize);
		clearMatrix();
		
		//̾̾Υԡ
		nameRowCopy(rowName);
		nameColCopy(colName);
	}
	
/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ<BR>
* ̾̾Ϲֹֹꤵޤ
* @param originalMatrix ꤹ2
* @exception NullPointerException  originalMatrix  null ξ
*/
	public StringMatrix(String[][] originalMatrix){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2򸵤˥ǡ¸Ѥ2ȹ̾̾
* ꤵ줿ֹ椫˹̾̾ޤ<BR>
* ̾̾ nameNumber ǻꤵ줿ֹ椫ꤵޤ
* @param originalMatrix ꤹ2
* @param nameNumber ̾̾γֹ
* @exception NullPointerException  originalMatrix  null ξ
*/
	public StringMatrix(String[][] originalMatrix, int nameNumber){
		super(originalMatrix.length, originalMatrix[0].length, nameNumber);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
	}

/**
* ꤵ줿2󡢹̾̾򸵤˥ǡ¸Ѥ2ȹ̾̾ޤ
* @param originalMatrix ꤹ2
* @param rowName ꤹ̾
* @param colName ꤹ̾
* @exception DisagreementArraySizeException ޥȥꥯλꤷȹ̾̾Ѥȥۤʤ
* @exception NullPointerException rowName , colName ޤ originalMatrix  null ξ
*/
	public StringMatrix(String[][] originalMatrix, String[] rowName, String[] colName){
		super(originalMatrix.length, originalMatrix[0].length);
		
		//ޥȥꥯΥԡ
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				setCell(i, j, originalMatrix[i][j]);
			}
		}
		
		//̾̾Υԡ
		nameRowCopy(rowName);
		nameColCopy(colName);
	}

/**
* ݻ줿Ǥѹ˥ޥȥꥯ礭ѹޤ
* ޥȥꥯ򾮤ϻꤷǤ礭ʬʤʤޤ
* 礭礭줿ʬϽͤǽ졢
* ̾̾Ϥ줾ֹֹˤʤޤ
* @param rowLength ԥ
* @param colLength 󥵥
* @exception NegativeMatrixSizeException ΥΥޥȥꥯ褦Ȥ
*/
	public void reSizeMatrix(int rowLength, int colLength){
		int r = getRowLength();
		int c = getColLength();
		super.reSizeMatrix(rowLength, colLength);
		
		
		//ޥȥꥯǤ
		for (int i = 0; i < rowLength; i++){
			if(i >= r){
				setRowName(i, i+"");
			}
			for (int j = 0; j < colLength; j++){
				if(j >= c){
					setColName(j, j+"");
				}
				if((i >= r) || (j >= c)){
					setCell(i, j, MATRIX_CLEAR_VALUE);
				}
			}
		}
	}

/**
* ꤵ줿1ͤꤷޤ
* @param row ֹ
* @param col ֹ
* @param ch 
* @exception NotElementException ꤷ¸ߤʤ
*/
	public void setCell(int row,int col,String ch){
		if (isMatrixEntityPoint(row, col)){
			super.setCell(row,col,ch);
		}
		else{
			throw new NotElementException("Point(" + row + "," + col + ")");
		}
	}

/**
* ޥȥꥯ¾Υޥȥꥯǡ̾̾Ƥ򥳥ԡޤ<BR>
* ԡΥޥȥꥯȰפʤϥԡΥޥȥꥯѹԡԤޤ
* @param originalMatrix ԡΥޥȥꥯ
* @see #matrixCopy(StringMatrix originalMatrix, int baseRow, int baseCol, int copyRow,int copyCol, int rowLength, int colLength)
*/
	public void matrixCopy(StringMatrix originalMatrix){
		super.matrixCopy(originalMatrix);
	}
	
/**
* ֤ǳϤǤ饳ԡΥޥȥꥯλ֤Ǥ򥳥ԡޤ<BR>
* ԡ( baseRow , baseCol )ǻꤵ줿Ǥ򳫻ϰ֤ȤrowLength  colLength ʬ
* ( copyRow , copyCol )ꤵǤϤޤǤ˥ԡԤޤ
* ԡϰϤƤϤޤʤǤȹ̾̾ѹޤ
* @param originalMatrix ԡΥޥȥꥯ
* @param baseRow ԡΥޥȥꥯФ륳ԡιԳϰ
* @param baseCol ԡΥޥȥꥯФ륳ԡ󳫻ϰ
* @param copyRow ԡԳϰ
* @param copyCol ԡ󳫻ϰ
* @param rowLength ԡԤԤǿ
* @param colLength ԡԤǿ
* @exception SetValueOutOfBoundsException ԡ褬¸ߤʤϰϤˤ
* @see #matrixCopy(StringMatrix originalMatrix)
*/
	public void matrixCopy(StringMatrix originalMatrix, int baseRow, int baseCol, int copyRow,
		int copyCol, int rowLength, int colLength){
			super.matrixCopy(originalMatrix, baseRow, baseCol, copyRow,
				copyCol, rowLength, colLength);
	}
	
/**
* ޥȥꥯ¸ߤƤ""ޤ
*/
	public void clearMatrix(){
		for (int i = 0 ; i < getRowLength() ; i++){
			for (int j = 0 ; j < getColLength() ; j++){
				setCell(i, j, MATRIX_CLEAR_VALUE);
			}
		}
	}
	
/**
* ꤵ줿1֤ͤޤ
* @param row ֹ
* @param col ֹ
* @return ꤷ
* @exception NotElementException ꤵ줿¸ߤʤ
*/
	public String getCell(int row, int col){
		if (isMatrixEntityPoint(row, col)){
			String s = (String)getObjectCell(row,col);
			return s;
		}
		else{
			throw new NotElementException("point(" + row + "," + col + ")");
		}
	}
	
/**
* ޥȥꥯ¸ߤǤΤǤǤʤǤο֤ޤ
* @return ǿ
*/
	public int getElement(){
		int element = 0;
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
				if (getCell(i, j) != MATRIX_VALUE_FALSE){
					element = element + 1;
				}
			}
		}
		return element;
	}
	
/**
* StringMatrixMatrixѴޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @return Ѵ줿Matrix
* @exception EduNumberFormatException ʸ󤬹ʸϲǽ double ͤޤޤʤ
* @see #toBooleanMatrix()
*/
	public ArithmeticMatrix toArithmeticMatrix(){
		try{
			ArithmeticMatrix returnMatrix = new ArithmeticMatrix(getRowLength(), getColLength(),
				getRowNameArray(), getColNameArray());
			for (int i = 0; i < getRowLength(); i++){
				for (int j = 0; j < getColLength(); j++){
						returnMatrix.setCell(i, j, Double.valueOf(getCell(i, j)));
					
				}
			}
			return returnMatrix;
		}
		catch(NumberFormatException e){
			throw new EduNumberFormatException();
		}
	}
	
/**
* StringMatrixBooleanMatrixѴޤ
* ʸ"true"(ʸȾʸ϶̤ʤ)trueˡʳʸfalseˤʤޤ
* Ѵ줿ޥȥꥯˤϹ̾̾ϰѤޤ
* @return Ѵ줿Matrix
* @see #toArithmeticMatrix()
*/
	public BooleanMatrix toBooleanMatrix(){
		BooleanMatrix returnMatrix = new BooleanMatrix(getRowLength(), getColLength(),
			getRowNameArray(), getColNameArray());
		for (int i = 0; i < getRowLength(); i++){
			for (int j = 0; j < getColLength(); j++){
					returnMatrix.setCell(i, j, Boolean.valueOf(getCell(i, j)));
			}
		}
		return returnMatrix;
	}
	
/**
* 2ĤΥޥȥꥯΥƱåޤ
* @param compareMatrix Ĵ٤ޥȥꥯ
* @return ƱǤTrue򡢰㤦False֤ޤ
*/
	public boolean isSameMatrixSize(StringMatrix compareMatrix){
		return getRowLength() == compareMatrix.getRowLength()
			&& getColLength() == compareMatrix.getColLength();
	}
	
/**
* ޥȥꥯǤ2֤ޤ
* @return Ǥ2
*/
	public String[][] getMatrix(){
		String st[][] = new String[getRowLength()][getColLength()];
		Object o[][] = new Object[getRowLength()][getColLength()];
		o = getObjectMatrix();
		for(int i=0; i < getRowLength(); i++){
			for(int j=0; j < getColLength(); j++){
				st[i][j] = (String)o[i][j];
			}
		}
		return st;
	}
}