package jp.ac.takushoku_u.cs;
import javax.swing.JFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;

/**
* Graphpaint饹ϥդ褹뤿Υ饹Ǥ
* @version 1.0
* @author  ͵(Kasajima Hiroshi)
* @see jp.ac.takushoku_u.cs.ArrangePoint
* @see jp.ac.takushoku_u.cs.SSGraphPoint
*/
/*
* ǽ 2005ǯ0301
*/
public class GraphPaint extends JFrame{
	
/**
* ܥޥȥꥯ
*/
	private BooleanMatrix matrix;
	
/**
* ãޥȥꥯ
*/
	private BooleanMatrix reachMatrix;
	
/**
* ٥(٥0Ϥޤ뤿ºݤΥ٥Ϻ٥+1)
*/
	private int maxLevel;
	
/**
* 粣
*/
	private int maxWide;
	
/**
* ǿ
*/
	private int elementNumber;
	
/**
* ٥(ǿ)
*/
	private int[] paintLevel;
	
/**
* Ʊ٥Ǥ
*/
	private int[] paintNumber;
	
/**
* (ϥ٥)
*/
	private int[] paintWide;
	
/**
* Ǥx,yɸ
*/
	private int[][] paintPoint;
	
/**
* դǤΥ
*/
	private int elmentSize = 20;
	
/**
* 1ǤΥ֥å
*/
	private int elementBlock = 50;
	
/**
* 󥹥ȥ饯ȴɤ
*/
	private boolean isCon = false;
	
/**
* ե졼x
*/
	private int xp;
/**
* ե졼y
*/
	private int yp;
	
/**
* 褹ļκ
*/
	private double maxValue = Double.NaN;
	
/**
* ļ
*/
	private int scale = 10;
	
/**
* Хå顼
*/
	private Color bkColor = Color.white;
	
/**
* ο
*/
	private Color arColor = Color.red;
	
/**
* ļο
*/
	private Color rowColor = Color.magenta;
	
/**
* ļο
*/
	private Color rowNumberColor = Color.darkGray;
	
/**
* 褹Ǥο
*/
	private Color elColor = Color.cyan;
	
/**
* ֹο
*/
	private Color elNumberColor = Color.black;
	
	
/**
* ǤΤʤܥޥȥꥯꤷԤޤ
*/
	public GraphPaint(){
		super("");
		BooleanMatrix mat = new BooleanMatrix();
		setMatrix(mat);
		setPaintArray();
		setPointArray();
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = (maxWide+1)*elementBlock;
		yp = (maxLevel+2)*elementBlock;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}
	
/**
* ܥޥȥꥯꤷԤޤ
* ۴Ĥǡλޤʤհʳưݾ㤵ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public GraphPaint(BooleanMatrix adjacencyMatrix){
		super("LFG");
		setMatrix(adjacencyMatrix);
		setPaintArray();
		setPointArray();
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = (maxWide+1)*elementBlock;
		yp = (maxLevel+2)*elementBlock;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}

/**
* ܥޥȥꥯȥ٥󡢺ɸ֤ꤷԤޤ
* LFG󥰥դȤä褹뤿۴Ĥǡλޤʤ
* ļ˥٥ʳͤȤʤդ褹뤿Υ󥹥ȥ饯Ǥ
* @param adjacencyMatrix ܥޥȥꥯ
* @param pointArray ǤֺɸǼ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
* @see jp.ac.takushoku_u.cs.ArrangePoint
* @see jp.ac.takushoku_u.cs.ArrangePoint#getPointArray()
*/
	public GraphPaint(BooleanMatrix adjacencyMatrix, int[][] pointArray){
		super("LFG");
		setMatrix(adjacencyMatrix);
		setPointArray(pointArray);
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = getMaxXPoint(pointArray) + elementBlock;
		yp = getMaxYPoint(pointArray) + elementBlock;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}
	
/**
* ܥޥȥꥯȥ٥󡢺ɸ֤ꤷԤޤ
* ļ꤬ɬפǤ륰աSSդΥ󥹥ȥ饯Ǥ
* Υ󥹥ȥ饯ѤȽļ褵ޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @param pointArray ǤֺɸǼ
* @param max ļκ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
* @see jp.ac.takushoku_u.cs.SSGraphPoint
* @see jp.ac.takushoku_u.cs.SSGraphPoint#getPointArray()
*/
	public GraphPaint(BooleanMatrix adjacencyMatrix, int[][] pointArray, double max){
		super("SSGraph");
		setMatrix(adjacencyMatrix);
		setPointArray(pointArray);
		isCon = true;
		
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		xp = getMaxXPoint(pointArray) + elementBlock;
		yp = 700;//((getMaxYPoint(pointArray) / elementBlock)+2) * elementBlock;
		maxValue = max;
		setSize(xp, yp);
		
		Container c = getContentPane();
		setBackground( bkColor );
		c.setBackground(getBackground());
		requestFocus();
		setVisible(true);
	}
	
/**
* դ褷ޤ
*/
	public void paint(Graphics g){
		
		//ļ褷ޤ
		if(!Double.isNaN(maxValue)){
			
			//迧
			g.setColor(rowColor);
			
			//ļ
			g.drawLine(elementBlock*4/5, elementBlock+elmentSize/2, elementBlock*4/5, (yp - elementBlock)+elmentSize/2);
			
			//ļδֳ
			int interval;
			if((yp * 1.0 - elementBlock) % (scale+1.0) >= (scale+1.0) / 2.0 ){
				interval = (yp - elementBlock) / (scale+1);
			}
			else{
				interval = (yp - elementBlock) / (scale+1) + 1;
			}
			for(int i = 0; i <= scale; i++){
				g.setColor(rowColor);
				g.drawLine(elementBlock*3/5,interval * i + (elementBlock + elmentSize/2),
					elementBlock*4/5,interval * i + (elementBlock + elmentSize/2));
				
				//
				g.setColor(rowNumberColor);
				g.drawString(""+(maxValue - (maxValue*i) / scale ), elementBlock*1 / 10,
					interval * i + (elementBlock + elmentSize/2));
			}
			System.out.println();
		}
		
		
		//Ǥ褷ޤ
		for(int i = 0; i < matrix.getRowLength(); i++){
			g.setColor(elColor);
			g.fillOval(paintPoint[i][0], paintPoint[i][1], elmentSize, elmentSize); //(x,y,礭,礭)
			g.setColor(elNumberColor);
			if(i < 10){
				g.drawString(i+"",paintPoint[i][0]+(elmentSize/4),paintPoint[i][1]+(elmentSize*3/4));
			}
			else{
				g.drawString(i+"",paintPoint[i][0]+(elmentSize/10),paintPoint[i][1]+(elmentSize*3/4));
			}
		}
		
		
		//ƻޤ褷ޤ
		for(int i = 0; i < matrix.getRowLength(); i++){
			g.setColor(arColor);
			for(int j = 0; j < matrix.getColLength(); j++){
				if(matrix.getCell(i,j)){
					
					//
					//x0 xɸ,yɸ
					//x1 xɸ,y1 yɸ,arrow Ĺ
					int x0, y0, x1, y1;
					
					//夫鲼ذȤ
					if(paintPoint[j][1] > paintPoint[i][1]){
						x0 = paintPoint[i][0] + elmentSize / 2;
						y0 = paintPoint[i][1] + elmentSize;
						x1 = paintPoint[j][0] + elmentSize / 2;
						y1 = paintPoint[j][1];
					}
					//Ʊ٥˰Ȥ
					else if(paintPoint[j][1] == paintPoint[i][1]){
						if(paintPoint[j][0] >= paintPoint[i][0]){
							x0 = paintPoint[i][0] + elmentSize;
							y0 = paintPoint[i][1] + elmentSize / 2;
							x1 = paintPoint[j][0];
							y1 = paintPoint[j][1] + elmentSize / 2;
						}
						else{
							x0 = paintPoint[i][0];
							y0 = paintPoint[i][1] + elmentSize / 2;
							x1 = paintPoint[j][0] + elmentSize;
							y1 = paintPoint[j][1] + elmentSize / 2;
						}
					}
					//ʳ
					else{
						x0 = paintPoint[i][0] + elmentSize / 2;
						y0 = paintPoint[i][1];
						x1 = paintPoint[j][0] + elmentSize / 2;
						y1 = paintPoint[j][1] + elmentSize;
					}
					
					int arrow = 7;
					double theta;
					
					//x,y
					int x,y;
					double dt = Math.PI / 6.0;
					theta = Math.atan2((double)(y1-y0),(double)(x1-x0));
					g.drawLine(x0,y0,x1,y1);
					x = x1-(int)(arrow*Math.cos(theta-dt));
					y = y1-(int)(arrow*Math.sin(theta-dt));
					g.drawLine(x1,y1,x,y);
					x = x1-(int)(arrow*Math.cos(theta+dt));
					y = y1-(int)(arrow*Math.sin(theta+dt));
					g.drawLine(x1,y1,x,y);
				}
			}
		}
	}
	
	
/**
* ٥֤ޤ
* @param levelArray ٥뤬ä
* @return ٥
*/
	private int getRowMaxLevel(int[] levelArray){
		int num = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] > num){
				num = levelArray[i];
			}
		}
		return num;
	}
	
/**
* 粣֤ޤ
* @param levelArray ٥뤬ä
* @return 粣
*/
	private int getColMaxLevel(int[] levelArray){
		int maxCount = 0;
		for(int i = 0; i < levelArray.length; i++){
			int count = 0;
			for(int j = 0; j < levelArray.length; j++){
				if(levelArray[j] == i){
					count++;
				}
			}
			if(count > maxCount){
				maxCount = count;
			}
		}
		
		return maxCount;
	}
	
/**
* ꤷ٥βõޤ
* @param level ꤹ٥
* @param levelArray ٥뤬ä
* @return 
*/
	private int getColLevel(int level, int[] levelArray){
		int count = 0;
		for(int i = 0; i < levelArray.length; i++){
			if(levelArray[i] == level){
				count++;
			}
		}
		
		return count;
	}
	
/**
* ԤդܥޥȥꥯȤꤷޤ
* @param adjacencyMatrix ܥޥȥꥯ
* @exception NotSquareMatrixException ꤷޥȥꥯǤϤʤ
*/
	public void setMatrix(BooleanMatrix adjacencyMatrix){
		matrix = new BooleanMatrix();
		reachMatrix = new BooleanMatrix();
		if(adjacencyMatrix.isSquare()){
			matrix.matrixCopy(adjacencyMatrix);
			reachMatrix.matrixCopy(matrix.getReachMatrix());
			if(isCon){
				setPaintArray();
			}
		}
		else{
			throw new NotSquareMatrixException("row("+ adjacencyMatrix.getRowLength() +
				"),col("+adjacencyMatrix.getColLength()+")");
		}
	}
	
/**
* Τꤷޤ
* ܥޥȥꥯ鼫ưޤ
*/
	private void setPaintArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		System.arraycopy(getLevelArray(), 0, returnArray, 0, matrix.getRowLength());
		setPaintArray(returnArray);
	}
	
/**
* դݤΥ٥Ȥ֤ޤ
* @return ٥Ǽ
*/
	private int[] getLevelArray(){
		int[] returnArray = new int[matrix.getRowLength()];
		BooleanMatrix reachMatrix= new BooleanMatrix();
		reachMatrix.matrixCopy(matrix.getReachMatrix());
		
		//ν
		for(int i = 0; i < returnArray.length; i++){
			returnArray[i] = -1;
		}
		
		//롼Ȥ
		for(int i = 0; i < returnArray.length; i++){
			if(matrix.getRowSum(i) == 0){
				returnArray[i] = 0;
			}
		}
		
		boolean flag = true;
		
		//٥Ǽ
		for(int level = 0; level < returnArray.length && flag; level++){
			for(int i = 0; i < returnArray.length; i++){
				
				//٥뤬ꤷƤʤ
				if(returnArray[i] == -1){
					int count = 1;
					for(int j = 0; j < returnArray.length; j++){
						
						//ޤǤϥ٥뤬ꤷƤ뤫
						if(reachMatrix.getCell(i, j) && returnArray[j] >= 0 &&
							returnArray[j] < level){
							count++;
						}
						else if(matrix.getCell(i, j) && matrix.getCell(j, i)){
							count++;
						}
					}
					if(count == reachMatrix.getRowSum(i)){
						returnArray[i] = level;
					}
				}
			}
		}
		
		//롼Ȥΰ֤ѹ
		for(int i = 0; i < returnArray.length; i++){
			if(returnArray[i] == 0){
				int count = 0;
				for(int j = 0; j < matrix.getRowLength(); j++){
					if(matrix.getCell(j,i)){
						if(count < returnArray[j]){
							count = returnArray[j];
						}
					}
				}
				returnArray[i] = count - 1;
			}
		}
		
		return returnArray;
	}
	
/**
* Τꤷޤ
* @param levelArray ǤɤΥ٥֤뤫٥ֹǼ
* @exception DisagreementArraySizeException ޥȥꥯΥפʤ
*/
	public void setPaintArray(int[] levelArray){
		if(matrix.getRowLength() == levelArray.length){
			maxLevel = getRowMaxLevel(levelArray);
			maxWide = getColMaxLevel(levelArray);
			elementNumber = levelArray.length;
			
			paintLevel = new int[levelArray.length];
			System.arraycopy(levelArray, 0, paintLevel, 0, levelArray.length);
			paintWide = new int[maxLevel+1];
			for(int i = 0; i <= maxLevel; i++){
				paintWide[i] = getColLevel(i, levelArray);
			}
			setPointArray();
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+levelArray.length+")");
		}
	}
	
/**
* ֻΤꤷޤ
* ܥޥȥꥯ鼫ưޤ
*/
	private void setPointArray(){
		paintPoint = new int[elementNumber][2];
		setPaint();
	}
	
/**
* ֻΤꤷޤ
* @param pointArray ־
*/
	public void setPointArray(int[][] pointArray){
		if(matrix.getRowLength() == pointArray.length){
			paintPoint = new int[pointArray.length][2];
			for(int i = 0; i < pointArray.length; i++){
				System.arraycopy(pointArray[i], 0, paintPoint[i], 0, pointArray[i].length); 
			}
			
		}
		else{
			throw new DisagreementArraySizeException("matrix("+matrix.getRowLength()+
				"),array("+pointArray.length+")");
		}
	}
	
/**
* ־ꤷޤ
*/
	private void setPaint(){
		//ƥ٥Ǵǿ򥫥Ȥޤ
		int[] countArray = new int [maxLevel+1];
		for(int i = 0; i <= maxLevel; i++){
			if(maxWide%2==0){
				countArray[i] = (maxWide + 1 - paintWide[i]) / 2;
			}
			else{
				countArray[i] = (maxWide - paintWide[i]) / 2;
			}
		}
		
		
		//Ǥxɸyɸޤ
		for(int i = 0; i < elementNumber; i++){
				
			//
			if(paintWide[paintLevel[i]]%2 == 0){
				if(countArray[paintLevel[i]]+1 == maxWide/2+1){
					countArray[paintLevel[i]]++;
				}
				paintPoint[i][0] = (countArray[paintLevel[i]] + 1) * elementBlock;
				countArray[paintLevel[i]]++;
			}
			
			//
			else{
				paintPoint[i][0] = (countArray[paintLevel[i]] + 1) * elementBlock;
				countArray[paintLevel[i]]++;
			}
			
			//yɸι⤵
			paintPoint[i][1] = (paintLevel[i]+1) * elementBlock;
		}
	}
	
/**
* 󤫤xκͤޤ
* @param pointArray ־
*/
	private int getMaxXPoint(int[][] pointArray){
		int max = -1;
		for(int i = 0; i < pointArray.length; i++){
			if(pointArray[i][0] > max){
				max = pointArray[i][0];
			}
		}
		return max;
	}
	
/**
* 󤫤yκͤޤ
* @param pointArray ־
*/
	private int getMaxYPoint(int[][] pointArray){
		int max = -1;
		for(int i = 0; i < pointArray.length; i++){
			if(pointArray[i][1] > max){
				max = pointArray[i][1];
			}
		}
		return max;
	}
	
/**
* 褵ͭޤοѹޤ
* ꤷʤϥǥեȿ(red)Ȥʤޤ
* @param c ꤹ뿧
*/
	public void setArrowColor(Color c){
		arColor = c;
		repaint();
	}
	
/**
* ļοѹޤ
* ꤷʤϥǥեȿ(magenta)Ȥʤޤ
* @param c ꤹ뿧
*/
	public void setRowLineColor(Color c){
		rowColor = c;
		repaint();
	}
	
/**
* ļ()οѹޤ
* ꤷʤϥǥեȿ(darkGray)Ȥʤޤ
* @param c ꤹ뿧
*/
	public void setRowLineNumberColor(Color c){
		rowNumberColor = c;
		repaint();
	}
	
/**
* 褹Ǥοѹޤ
* ꤷʤϥǥեȿ(cyan)Ȥʤޤ
* @param c ꤹ뿧
*/
	public void setElementColor(Color c){
		elColor = c;
		repaint();
	}
	
/**
* ֹοѹޤ
* ꤷʤϥǥեȿ(black)Ȥʤޤ
* @param c ꤹ뿧
*/
	public void setElementNumberColor(Color c){
		elNumberColor = c;
		repaint();
	}
	
}