/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.sed.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;

import blanco.commons.util.BlancoStringUtil;
import blanco.sed.BlancoSed;
import blanco.sed.BlancoSedConstants;
import blanco.sed.task.valueobject.BlancoSedProcessInput;

/**
 *  [BlancoSedProcess]C^tF[XB
 * 
 * @author IGA Tosiki
 */
public class BlancoSedProcessImpl implements BlancoSedProcess {
    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(final BlancoSedProcessInput input) throws IOException,
            IllegalArgumentException {
        System.out.println("- " + BlancoSedConstants.PRODUCT_NAME + " ("
                + BlancoSedConstants.VERSION + ")");

        final File fileInput = new File(input.getInput());
        final File fileOutput = new File(input.getOutput());
        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("sed: ̓t@C܂: "
                    + fileInput.getAbsolutePath());
        }
        if (fileInput.isFile() == false) {
            throw new IllegalArgumentException("sed: ̓t@C̓t@Cł͂܂: "
                    + fileInput.getAbsolutePath());
        }
        if (fileInput.canRead() == false) {
            throw new IllegalArgumentException("sed: ̓t@Cǂݍ߂܂: "
                    + fileInput.getAbsolutePath());
        }
        if (fileOutput.exists()) {
            if (fileOutput.isFile() == false) {
                throw new IllegalArgumentException(
                        "sed: o̓t@Cɑ݂At@Cł͂܂: "
                                + fileOutput.getAbsolutePath());
            }
            if (fileOutput.canWrite() == false) {
                throw new IllegalArgumentException("sed: o̓t@Cɏ݂ł܂: "
                        + fileOutput.getAbsolutePath());
            }
        }

        if (BlancoStringUtil.null2Blank(input.getScriptfile()).length() > 0) {
            final File fileScriptFile = new File(input.getScriptfile());
            if (fileScriptFile.exists() == false) {
                throw new IllegalArgumentException("sed: XNvgt@C݂܂: "
                        + fileScriptFile.getAbsolutePath());
            }
            if (fileScriptFile.isFile() == false) {
                throw new IllegalArgumentException(
                        "sed: XNvgt@C̓t@Cł͂܂: "
                                + fileScriptFile.getAbsolutePath());
            }
        }
        if (BlancoStringUtil.null2Blank(input.getScript()).length() == 0
                && BlancoStringUtil.null2Blank(input.getScriptfile()).length() == 0) {
            throw new IllegalArgumentException(
                    "scriptscriptfilêw肳Ă܂Bꂩw肵ĂB");
        }
        if (BlancoStringUtil.null2Blank(input.getScript()).length() > 0
                && BlancoStringUtil.null2Blank(input.getScriptfile()).length() > 0) {
            throw new IllegalArgumentException(
                    "scriptscriptfile̗w肳Ă܂Bꂩw肵ĂB");
        }

        BufferedReader reader = null;
        BufferedWriter writer = null;
        BufferedReader readerScriptFile = null;
        try {
            if (BlancoStringUtil.null2Blank(input.getScript()).length() > 0) {
                readerScriptFile = new BufferedReader(new StringReader(input
                        .getScript()));
            } else {
                readerScriptFile = new BufferedReader(new InputStreamReader(
                        new FileInputStream(input.getScriptfile()), input
                                .getEncoding()));
            }

            reader = new BufferedReader(new InputStreamReader(
                    new FileInputStream(input.getInput()), input.getEncoding()));
            writer = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream(input.getOutput()), input
                            .getEncoding()));

            BlancoSed.process(reader, writer, readerScriptFile);

        } finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
            if (readerScriptFile != null) {
                readerScriptFile.close();
            }
        }

        return BlancoSedBatchProcess.END_SUCCESS;
    }
}
