package jp.ac.osaka_u.sanken.sparql.gui;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import jp.ac.osaka_u.sanken.sparql.EndpointSettings;
import jp.ac.osaka_u.sanken.util.CheckableList;
import jp.ac.osaka_u.sanken.util.CheckableListItem;

public class EndpointSelector extends JDialog {

	/**
	 *
	 */
	private static final long serialVersionUID = -5270916655051535400L;
	private EndpointSettings[] settings;
	private Map<String, EndpointSettings> settingNames;

	private JPanel jContentPane;
	private CheckableList endpointList;
	private JScrollPane endpointListScrollPane;
	private JPanel buttonPane;
	private JButton okButton;
	private boolean valid = false;

	public EndpointSelector(Frame owner, EndpointSettings[] settings){
		super(owner);

		this.settings = settings;
		this.settingNames = new LinkedHashMap<String, EndpointSettings>();
		this.setTitle("Select the target endpoints");
		for (EndpointSettings setting : settings){
			settingNames.put(setting.getEndpoint(), setting);
		}

		initialize();
	}

	public boolean isValid(){
		return valid;
	}

	public EndpointSettings[] getSettings(){
		DefaultListModel model = (DefaultListModel)getEndpointList().getModel();
		for (int i=0; i<model.getSize(); i++){
			CheckableListItem item = (CheckableListItem)model.getElementAt(i);
			EndpointSettings ep = settingNames.get(item.text);
			if (ep != null){
				ep.setTarget(item.selected);
			}
		}

		return settings;
	}


	/**
	 * This method initializes this
	 *
	 * @return void
	 */
	private void initialize() {
		this.setSize(400, 400);
		this.setContentPane(getJContentPane());
		this.setResizable(false);
		this.setModal(true);
		InputMap imap = getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
		imap.put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "go");
		getRootPane().getActionMap().put("go", new AbstractAction() {
			/**
			 * 
			 */
			private static final long serialVersionUID = -4361937227644962283L;

			@Override
			public void actionPerformed(ActionEvent e) {
				valid = true;
				close();
			}
		});
	}

	private JPanel getJContentPane() {
		if (jContentPane == null){
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
//			jContentPane.add(new JLabel("Select the target endpoints"), BorderLayout.NORTH);
			jContentPane.add(getEndpointListScrollPane(), BorderLayout.CENTER);
			jContentPane.add(getButtonPane(), BorderLayout.SOUTH);
		}

		return jContentPane;

	}

	private CheckableList getEndpointList(){
		if (endpointList == null){
			DefaultListModel model = new DefaultListModel();
			for (EndpointSettings setting : settings){
				model.addElement(new CheckableListItem(setting.getEndpoint(), setting.isTarget()));
			}

			endpointList = new CheckableList(model);
		}
		return endpointList;
	}

	private JScrollPane getEndpointListScrollPane(){
		if (endpointListScrollPane == null){
			endpointListScrollPane = new JScrollPane(getEndpointList());
		}
		return endpointListScrollPane;
	}

	private JPanel getButtonPane(){
		if (buttonPane == null){
			buttonPane = new JPanel();
			buttonPane.setLayout(new BorderLayout());
			buttonPane.add(getOKButton(), BorderLayout.EAST);
		}

		return buttonPane;
	}
	private JButton getOKButton(){
		if (okButton == null){
			okButton = new JButton("OK");
			okButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					valid = true;
					close();
				}
			});
		}
		return okButton;
	}



	private void close(){
		this.setVisible(false);
	}

}
