package jp.ac.osaka_u.sanken.sparql;



public interface ThreadedSparqlAccessor extends SparqlAccessor {

	/**
	 * Sparql Queryを直接指定して実行し、結果を返す
	 * @param queryString
	 * @param resultListener
	 * @return Thread開始したか
	 */
	public boolean executeQuery(String queryString, SparqlResultListener resultListener);

	/**
	 * 文字列に該当するSubjectを検索して結果を返す
	 * @param word
	 * @param fullMatch
	 * @param limit
	 * @param offset
	 * @param type
	 * @param propList
	 * @param resultListener
	 * @return Thread開始したか
	 */
	public boolean findSubject(String word, boolean fullMatch, Integer limit, Integer offset, int type, String[] propList, SparqlResultListener resultListener);

	/**
	 * SubjectにヒットするTripleを検索して結果を返す
	 * @param subject
	 * @param listener
	 * @return Thread開始したか
	 */
	public boolean findTripleFromSubject(String subject, SparqlResultListener listener);


	/**
	 * propertyの一覧を取得する
	 * @param listener
	 * @return Thread開始したか
	 */
	public boolean  findPropertyList(SparqlResultListener listener);

}
