package jp.ac.osaka_u.sanken.sparql;

import java.util.List;

public class SparqlAccessorFactory {

	public static SparqlAccessor createSparqlAccessor(EndpointSettings setting){
		
		if (setting.isEditable()){
			// 現状、編集可能なら常にAllegroGraphとする
			return new AllegroAccessor(setting);
		} else {
			return new PlainSparqlAccessor(setting);
		}
	}

	public static SparqlAccessor createSparqlAccessor(List<EndpointSettings> settings){
		return new CrossSparqlAccessor(settings);
	}

	public static ThreadedSparqlAccessor createSparqlAccessor(EndpointSettings setting, SparqlQueryListener listener){
		
		if (setting.isEditable()){
			// 現状、編集可能なら常にAllegroGraphとする
			return new AllegroAccessor(setting, listener);
		} else {
			return new PlainSparqlAccessor(setting, listener);
		}
	}

	public static ThreadedSparqlAccessor createSparqlAccessor(List<EndpointSettings> settings, SparqlQueryListener listener){
		return new CrossSparqlAccessor(settings, listener);
	}

	
}
