/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class BindingAssigner
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        if (bindings.size() > 0) {
            tupleExpr.visit(new VarVisitor(bindings));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class VarVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected BindingSet bindings;

        public VarVisitor(BindingSet bindings) {
            this.bindings = bindings;
        }

        @Override
        public void meet(Var var) {
            if (!var.hasValue() && this.bindings.hasBinding(var.getName())) {
                Value value = this.bindings.getValue(var.getName());
                var.setValue(value);
            }
        }
    }
}

