/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.sparql.query;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.httpclient.HttpMethod;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.TupleQueryResultImpl;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultParser;
import org.openrdf.repository.sparql.query.QueueCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundTupleResult
extends TupleQueryResultImpl
implements TupleQueryResult,
Runnable,
TupleQueryResultHandler {
    private volatile boolean closed;
    private volatile Thread parserThread;
    private TupleQueryResultParser parser;
    private InputStream in;
    private HttpMethod method;
    private QueueCursor<BindingSet> queue;
    private List<String> bindingNames;
    private CountDownLatch bindingNamesReady = new CountDownLatch(1);

    public BackgroundTupleResult(TupleQueryResultParser parser, InputStream in, HttpMethod connection) {
        this(new QueueCursor<BindingSet>(10), parser, in, connection);
    }

    public BackgroundTupleResult(QueueCursor<BindingSet> queue, TupleQueryResultParser parser, InputStream in, HttpMethod connection) {
        super((List<String>)Collections.EMPTY_LIST, queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.method = connection;
    }

    @Override
    public synchronized void close() throws QueryEvaluationException {
        this.closed = true;
        if (this.parserThread != null) {
            this.parserThread.interrupt();
        }
    }

    @Override
    public List<String> getBindingNames() {
        try {
            this.bindingNamesReady.await();
            this.queue.checkException();
            return this.bindingNames;
        }
        catch (InterruptedException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (QueryEvaluationException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean completed = false;
        this.parserThread = Thread.currentThread();
        try {
            this.parser.setTupleQueryResultHandler(this);
            this.parser.parse(this.in);
            this.method.releaseConnection();
            completed = true;
        }
        catch (TupleQueryResultHandlerException e) {
        }
        catch (QueryResultParseException e) {
            this.queue.toss(e);
        }
        catch (IOException e) {
            this.queue.toss(e);
        }
        finally {
            this.parserThread = null;
            this.queue.done();
            this.bindingNamesReady.countDown();
            if (!completed) {
                this.method.abort();
            }
        }
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        this.bindingNames = bindingNames;
        this.bindingNamesReady.countDown();
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        if (this.closed) {
            throw new TupleQueryResultHandlerException("Result closed");
        }
        try {
            this.queue.put(bindingSet);
        }
        catch (InterruptedException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
    }
}

