/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline.inf;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.pipeline.inf.InferenceProcessorRDFS;
import org.openjena.riot.pipeline.inf.InferenceSetupRDFS;

class InferenceProcessorQuads
implements Sink<Quad> {
    private final Sink<Quad> output;
    private final InferenceSetupRDFS rdfsSetup;
    private final InferenceProcessorRDFS rdfs;
    private Node g;

    public InferenceProcessorQuads(Sink<Quad> output, InferenceSetupRDFS rdfsSetup) {
        this.output = output;
        this.rdfsSetup = rdfsSetup;
        this.rdfs = new InferenceProcessorRDFS(rdfsSetup){

            @Override
            public void derive(Node s, Node p, Node o) {
                InferenceProcessorQuads.this.output.send(new Quad(InferenceProcessorQuads.this.g, s, p, o));
            }
        };
    }

    @Override
    public void send(Quad quad) {
        this.output.send(quad);
        this.g = quad.getGraph();
        this.rdfs.process(quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public void flush() {
        this.output.flush();
    }

    @Override
    public void close() {
        this.output.close();
    }
}

