/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.E_NotOneOf;
import com.hp.hpl.jena.sparql.expr.E_OneOf;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprAggregator;
import com.hp.hpl.jena.sparql.expr.ExprFunction;
import com.hp.hpl.jena.sparql.expr.ExprFunction0;
import com.hp.hpl.jena.sparql.expr.ExprFunction1;
import com.hp.hpl.jena.sparql.expr.ExprFunction2;
import com.hp.hpl.jena.sparql.expr.ExprFunction3;
import com.hp.hpl.jena.sparql.expr.ExprFunctionN;
import com.hp.hpl.jena.sparql.expr.ExprFunctionOp;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.syntax.Element;
import org.openjena.atlas.io.IndentedWriter;

public class FmtExpr {
    static final int INDENT = 2;
    FmtExprARQVisitor visitor;

    public FmtExpr(IndentedWriter writer, SerializationContext cxt) {
        this.visitor = new FmtExprARQVisitor(writer, cxt);
    }

    public void format(Expr expr) {
        expr.visit(this.visitor);
    }

    public static void format(IndentedWriter out, Expr expr) {
        FmtExpr.format(out, expr, null);
    }

    public static void format(IndentedWriter out, Expr expr, SerializationContext cxt) {
        FmtExpr fmt = new FmtExpr(out, cxt);
        fmt.format(expr);
    }

    private static class FmtExprARQVisitor
    implements ExprVisitor {
        IndentedWriter out;
        SerializationContext context;

        public FmtExprARQVisitor(IndentedWriter writer, PrefixMapping pmap) {
            this(writer, new SerializationContext(pmap, null));
        }

        public FmtExprARQVisitor(IndentedWriter writer, SerializationContext cxt) {
            this.out = writer;
            this.context = cxt;
            if (this.context == null) {
                this.context = new SerializationContext();
            }
        }

        @Override
        public void startVisit() {
        }

        @Override
        public void visit(ExprFunction0 expr) {
            if (expr.getOpName() == null) {
                this.printInFunctionForm(expr);
                return;
            }
            this.out.print("()");
        }

        @Override
        public void visit(ExprFunction1 expr) {
            if (expr.getOpName() == null) {
                this.printInFunctionForm(expr);
                return;
            }
            this.out.print("( ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
            expr.getArg().visit(this);
            this.out.print(" )");
        }

        @Override
        public void visit(ExprFunction2 expr) {
            if (expr.getOpName() == null) {
                this.printInFunctionForm(expr);
                return;
            }
            this.out.print("( ");
            expr.getArg1().visit(this);
            this.out.print(" ");
            this.out.print(expr.getOpName());
            this.out.print(" ");
            expr.getArg2().visit(this);
            this.out.print(" )");
        }

        @Override
        public void visit(ExprFunction3 expr) {
            this.printInFunctionForm(expr);
        }

        @Override
        public void visit(ExprFunctionN func) {
            if (func instanceof E_OneOf) {
                E_OneOf oneOf = (E_OneOf)func;
                this.out.print("( ");
                oneOf.getLHS().visit(this);
                this.out.print(" IN ");
                this.printExprList(oneOf.getRHS());
                this.out.print(" )");
                return;
            }
            if (func instanceof E_NotOneOf) {
                E_NotOneOf oneOf = (E_NotOneOf)func;
                this.out.print("( ");
                oneOf.getLHS().visit(this);
                this.out.print(" NOT IN ");
                this.printExprList(oneOf.getRHS());
                this.out.print(" )");
                return;
            }
            this.printInFunctionForm(func);
        }

        private void printInFunctionForm(ExprFunction func) {
            this.out.print(func.getFunctionPrintName(this.context));
            this.printExprList(func.getArgs());
        }

        private void printExprList(Iterable<Expr> exprs) {
            this.out.print("(");
            boolean first = true;
            for (Expr expr : exprs) {
                if (expr == null) break;
                if (!first) {
                    this.out.print(", ");
                }
                first = false;
                expr.visit(this);
            }
            this.out.print(")");
        }

        @Override
        public void visit(ExprFunctionOp funcOp) {
            FormatterElement fmtElt = new FormatterElement(this.out, this.context);
            this.out.print(funcOp.getFunctionName(this.context));
            this.out.print(" ");
            Element el = funcOp.getElement();
            if (el == null) {
                el = OpAsQuery.asQuery(funcOp.getGraphPattern()).getQueryPattern();
            }
            el.visit(fmtElt);
        }

        @Override
        public void visit(NodeValue nv) {
            this.out.print(nv.asQuotedString(this.context));
        }

        @Override
        public void visit(ExprVar nv) {
            String s = nv.getVarName();
            if (Var.isBlankNodeVarName(s)) {
                Var v = Var.alloc(s);
                this.out.print(this.context.getBNodeMap().asString((Node)v));
            } else {
                this.out.print(nv.asSparqlExpr());
            }
        }

        @Override
        public void visit(ExprAggregator eAgg) {
            this.out.print(eAgg.asSparqlExpr());
        }

        @Override
        public void finishVisit() {
            this.out.flush();
        }
    }
}

