/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.QueryCancelledException;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFatalException;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.NoSuchElementException;
import org.openjena.atlas.logging.Log;

public abstract class QueryIteratorBase
extends PrintSerializableBase
implements QueryIterator {
    public static boolean traceIterators = false;
    private boolean finished = false;
    private volatile boolean requestingCancel = false;
    private boolean abortIterator = false;
    private Object cancelLock = new Object();
    private Throwable stackTrace = null;

    public QueryIteratorBase() {
        if (traceIterators) {
            this.stackTrace = new Throwable();
        }
    }

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected abstract void requestCancel();

    protected boolean isFinished() {
        return this.finished;
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.requestingCancel && this.abortIterator) {
            this.close();
            throw new QueryCancelledException();
        }
        boolean r = this.hasNextBinding();
        if (!r) {
            try {
                this.close();
            }
            catch (QueryFatalException ex) {
                Log.fatal(this, "Fatal exception: " + ex.getMessage());
                this.abort();
                throw ex;
            }
        }
        return r;
    }

    @Override
    public final Binding next() {
        return this.nextBinding();
    }

    @Override
    public final Binding nextBinding() {
        try {
            boolean shouldCancel = this.requestingCancel;
            if (shouldCancel && this.abortIterator) {
                this.close();
                throw new QueryCancelledException();
            }
            if (this.finished) {
                throw new NoSuchElementException(Utils.className(this));
            }
            if (!this.hasNextBinding()) {
                throw new NoSuchElementException(Utils.className(this));
            }
            Binding obj = this.moveToNextBinding();
            if (obj == null) {
                throw new NoSuchElementException(Utils.className(this));
            }
            if (shouldCancel && !this.finished) {
                this.close();
            }
            return obj;
        }
        catch (QueryFatalException ex) {
            Log.fatal(this, "QueryFatalException", (Throwable)((Object)ex));
            this.abort();
            throw ex;
        }
    }

    @Override
    public final void remove() {
        Log.warn(this, "Call to QueryIterator.remove() : " + Utils.className(this) + ".remove");
        throw new UnsupportedOperationException(Utils.className(this) + ".remove");
    }

    @Override
    public void close() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException ex) {
            Log.warn(this, "QueryException in close()", (Throwable)((Object)ex));
        }
        this.finished = true;
    }

    @Override
    @Deprecated
    public void abort() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException queryException) {
            // empty catch block
        }
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.requestingCancel) {
                this.abortIterator = true;
                this.requestingCancel = true;
                this.requestCancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancelAllowContinue() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.requestingCancel) {
                this.requestingCancel = true;
                this.requestCancel();
            }
        }
    }

    protected static void performClose(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.close();
    }

    protected static void performRequestCancel(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.cancel();
    }

    public String debug() {
        String s = "";
        if (this.stackTrace != null) {
            for (int i = 0; i < this.stackTrace.getStackTrace().length; ++i) {
                StackTraceElement e2 = this.stackTrace.getStackTrace()[i];
                if (e2.getMethodName().equals("<init>")) continue;
                s = s + e2.toString();
                break;
            }
        }
        return s;
    }
}

