/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandler;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandlerRegistry;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorWrapper;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjena.atlas.lib.AlarmClock;
import org.openjena.atlas.lib.Callback;
import org.openjena.atlas.lib.Pingback;
import org.openjena.atlas.logging.Log;

public class QueryExecutionBase
implements QueryExecution {
    private Query query;
    private Dataset dataset;
    private QueryEngineFactory qeFactory;
    private QueryIterator queryIterator = null;
    private Plan plan = null;
    private Context context;
    private FileManager fileManager = FileManager.get();
    private QuerySolution initialBinding = null;
    private volatile boolean cancel = false;
    @Deprecated
    public static boolean cancelAllowDrain = false;
    private static final long TIMEOUT_UNSET = -1L;
    private static final long TIMEOUT_INF = -2L;
    private long timeout1 = -1L;
    private long timeout2 = -1L;
    private static AlarmClock alarmClock = AlarmClock.get();
    private static final Callback<QueryExecution> callback = new Callback<QueryExecution>(){

        @Override
        public void proc(QueryExecution qExec) {
            qExec.abort();
        }
    };
    private Pingback<QueryExecution> pingback = null;

    public QueryExecutionBase(Query query2, Dataset dataset, Context context, QueryEngineFactory qeFactory) {
        this.query = query2;
        this.dataset = dataset;
        this.context = context;
        this.qeFactory = qeFactory;
        this.init();
    }

    private void init() {
        DatasetGraph dsg = this.dataset == null ? null : this.dataset.asDatasetGraph();
        this.context = Context.setupContext(this.context, dsg);
        if (this.query != null) {
            this.context.put(ARQConstants.sysCurrentQuery, this.query);
        }
        this.setAnyTimeouts();
    }

    public static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset != null && dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactory.nowAsDateTime());
        return context;
    }

    private void setAnyTimeouts() {
        block8: {
            if (this.context.isDefined(ARQ.queryTimeout)) {
                Object obj = this.context.get(ARQ.queryTimeout);
                if (obj instanceof Number) {
                    long x = ((Number)obj).longValue();
                    this.setTimeout(x);
                } else if (obj instanceof String) {
                    try {
                        String str2 = obj.toString();
                        if (str2.contains(",")) {
                            String[] a = str2.split(",");
                            long x1 = Long.parseLong(a[0]);
                            long x2 = Long.parseLong(a[1]);
                            this.setTimeout(x1, x2);
                            break block8;
                        }
                        long x = Long.parseLong(str2);
                        this.setTimeout(x);
                    }
                    catch (RuntimeException ex) {
                        Log.warn(this, "Can't interpret string for timeout: " + obj);
                    }
                } else {
                    Log.warn(this, "Can't interpret timeout: " + obj);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.queryIterator != null) {
            this.queryIterator.close();
        }
        if (this.plan != null) {
            this.plan.close();
        }
        this.cancelPingback();
    }

    @Override
    public synchronized void abort() {
        if (this.queryIterator != null) {
            if (cancelAllowDrain && this.queryIterator instanceof QueryIteratorBase) {
                QueryIteratorBase qIter = (QueryIteratorBase)this.queryIterator;
                qIter.cancelAllowContinue();
            } else {
                this.queryIterator.cancel();
            }
            this.cancel = true;
        }
        this.cancel = true;
    }

    @Override
    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        return this.execResultSet();
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execConstruct(Model model) {
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.startQueryIterator();
        this.insertPrefixesInto(model);
        Template template = this.query.getConstructTemplate();
        while (this.queryIterator.hasNext()) {
            HashSet<Triple> set = new HashSet<Triple>();
            HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding binding = this.queryIterator.nextBinding();
            template.subst(set, bNodeMap, binding);
            for (Triple t : set) {
                Statement stmt = ModelUtils.tripleToStatement(model, t);
                if (stmt == null) continue;
                model.add(stmt);
            }
        }
        this.close();
        return model;
    }

    @Override
    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    @Override
    public Model execDescribe(Model model) {
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setResultVars();
        if (this.query.getQueryPattern() == null) {
            this.query.setQueryPattern(new ElementGroup());
        }
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        ResultSet qRes = this.execResultSet();
        this.insertPrefixesInto(model);
        if (qRes != null) {
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                for (String varName : this.query.getResultVars()) {
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
            this.close();
        }
        if (this.query.getResultURIs() != null) {
            for (Node n : this.query.getResultURIs()) {
                RDFNode rNode = ModelUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        List<DescribeHandler> dhList = DescribeHandlerRegistry.get().newHandlerList();
        this.getContext().put(ARQConstants.sysCurrentDataset, this.getDataset());
        for (DescribeHandler dh : dhList) {
            dh.start(model, this.getContext());
        }
        for (RDFNode n : set) {
            if (!(n instanceof Resource)) continue;
            for (DescribeHandler dh : dhList) {
                dh.describe((Resource)n);
            }
        }
        for (DescribeHandler dh : dhList) {
            dh.finish();
        }
        this.close();
        return model;
    }

    @Override
    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.startQueryIterator();
        boolean r = this.queryIterator.hasNext();
        this.close();
        return r;
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeUnit) {
        long x;
        this.timeout1 = x = QueryExecutionBase.asMillis(timeout, timeUnit);
        this.timeout2 = -1L;
    }

    @Override
    public void setTimeout(long timeout) {
        this.setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setTimeout(long timeout1, TimeUnit timeUnit1, long timeout2, TimeUnit timeUnit2) {
        long x1 = QueryExecutionBase.asMillis(timeout1, timeUnit1);
        long x2 = QueryExecutionBase.asMillis(timeout2, timeUnit2);
        this.timeout1 = x1;
        this.timeout2 = timeout2 < 0L ? -2L : x2;
    }

    @Override
    public void setTimeout(long timeout1, long timeout2) {
        this.setTimeout(timeout1, TimeUnit.MILLISECONDS, timeout2, TimeUnit.MILLISECONDS);
    }

    private static long asMillis(long duration, TimeUnit timeUnit) {
        return duration < 0L ? duration : timeUnit.toMillis(duration);
    }

    private void initTimeout1() {
        if (this.timeout1 == -1L) {
            return;
        }
        if (this.pingback != null) {
            alarmClock.reset(this.pingback, this.timeout1);
        } else {
            this.pingback = alarmClock.add(callback, this, this.timeout1);
        }
    }

    private QueryIterator initTimeout2(QueryIterator queryIterator) {
        if (this.timeout2 < 0L && this.timeout2 != -2L) {
            return queryIterator;
        }
        return new QueryIteratorWrapper(queryIterator){
            boolean resetDone;
            {
                this.resetDone = false;
            }

            @Override
            protected Binding moveToNextBinding() {
                Binding b = super.moveToNextBinding();
                if (!this.resetDone) {
                    if (QueryExecutionBase.this.pingback == null) {
                        if (QueryExecutionBase.this.timeout2 > 0L) {
                            QueryExecutionBase.this.pingback = alarmClock.add(callback, QueryExecutionBase.this, QueryExecutionBase.this.timeout2);
                        }
                    } else if (QueryExecutionBase.this.timeout2 < 0L) {
                        alarmClock.cancel(QueryExecutionBase.this.pingback);
                    } else {
                        QueryExecutionBase.this.pingback = alarmClock.reset(QueryExecutionBase.this.pingback, QueryExecutionBase.this.timeout2);
                    }
                    this.resetDone = true;
                }
                return b;
            }
        };
    }

    private void cancelPingback() {
        if (this.pingback != null) {
            alarmClock.cancel(this.pingback);
        }
    }

    protected final void execInit() {
    }

    private ResultSet asResultSet(QueryIterator qIter) {
        Model model = null;
        model = this.dataset != null ? this.dataset.getDefaultModel() : ModelFactory.createDefaultModel();
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), model, qIter);
        return rStream;
    }

    private void startQueryIterator() {
        this.execInit();
        if (this.queryIterator != null) {
            Log.warn(this, "Query iterator has already been started");
        }
        this.initTimeout1();
        this.queryIterator = this.getPlan().iterator();
        this.queryIterator = this.initTimeout2(this.queryIterator);
        if (this.cancel) {
            this.queryIterator.cancel();
        }
    }

    private ResultSet execResultSet() {
        this.startQueryIterator();
        return this.asResultSet(this.queryIterator);
    }

    public Plan getPlan() {
        if (this.plan == null) {
            DatasetGraph dsg = QueryExecutionBase.prepareDataset(this.dataset, this.query, this.fileManager);
            Binding inputBinding = null;
            if (this.initialBinding != null) {
                inputBinding = BindingUtils.asBinding(this.initialBinding);
            }
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            this.plan = this.qeFactory.create(this.query, dsg, inputBinding, this.getContext());
        }
        return this.plan;
    }

    private void insertPrefixesInto(Model model) {
        try {
            if (this.dataset != null) {
                Model m = this.dataset.getDefaultModel();
                model.setNsPrefixes((PrefixMapping)m);
            }
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            Log.warn(this, "Exception in insertPrefixes: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    private static DatasetGraph prepareDataset(Dataset dataset, Query query2, FileManager fileManager) {
        if (dataset != null) {
            return dataset.asDatasetGraph();
        }
        if (!query2.hasDatasetDescription()) {
            throw new QueryExecException("No dataset description for query");
        }
        String baseURI = query2.getBaseURI();
        if (baseURI == null) {
            baseURI = IRIResolver.chooseBaseURI();
        }
        DatasetGraph dsg = DatasetUtils.createDatasetGraph(query2.getGraphURIs(), query2.getNamedGraphURIs(), fileManager, baseURI);
        return dsg;
    }

    @Override
    public void setFileManager(FileManager fm) {
        this.fileManager = fm;
    }

    @Override
    public void setInitialBinding(QuerySolution startSolution) {
        this.initialBinding = startSolution;
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("setInitialBindings(ResultSet)");
    }
}

