/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.shared.LockMRSW;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.sse.writers.WriterGraph;
import com.hp.hpl.jena.sparql.util.Context;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.iterator.Iter;
import org.openjena.atlas.iterator.Transform;

public abstract class DatasetGraphBase
implements DatasetGraph {
    private final Lock lock = new LockMRSW();
    private Context context = new Context();

    protected DatasetGraphBase() {
    }

    @Override
    public boolean containsGraph(Node graphNode) {
        return this.contains(graphNode, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public abstract Graph getDefaultGraph();

    @Override
    public abstract Graph getGraph(Node var1);

    @Override
    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException("DatasetGraph.addGraph");
    }

    @Override
    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException("DatasetGraph.removeGraph");
    }

    @Override
    public void setDefaultGraph(Graph g) {
        throw new UnsupportedOperationException("DatasetGraph.setDefaultGraph");
    }

    @Override
    public void add(Quad quad) {
        throw new UnsupportedOperationException("DatasetGraph.add(Quad)");
    }

    @Override
    public void delete(Quad quad) {
        throw new UnsupportedOperationException("DatasetGraph.delete(Quad)");
    }

    @Override
    public void add(Node g, Node s, Node p, Node o) {
        this.add(new Quad(g, s, p, o));
    }

    @Override
    public void delete(Node g, Node s, Node p, Node o) {
        this.delete(new Quad(g, s, p, o));
    }

    @Override
    public void deleteAny(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        List<Quad> list = Iter.toList(iter);
        for (Quad q : list) {
            this.delete(q);
        }
    }

    @Override
    public Iterator<Quad> find() {
        return this.find(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public Iterator<Quad> find(Quad quad) {
        if (quad == null) {
            return this.find();
        }
        return this.find(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public boolean contains(Quad quad) {
        return this.contains(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    @Override
    public boolean contains(Node g, Node s, Node p, Node o) {
        Iterator<Quad> iter = this.find(g, s, p, o);
        boolean b = iter.hasNext();
        Iter.close(iter);
        return b;
    }

    protected static boolean isWildcard(Node g) {
        return g == null || g == Node.ANY;
    }

    @Override
    public boolean isEmpty() {
        return !this.contains(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void close() {
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        WriterGraph.output((IndentedWriter)out, this, null);
        return out.asString();
    }

    protected static Iterator<Quad> triples2quadsDftGraph(Iterator<Triple> iter) {
        return DatasetGraphBase.triples2quads(Quad.defaultGraphNodeGenerated, iter);
    }

    protected static Iter<Quad> triples2quads(final Node graphNode, Iterator<Triple> iter) {
        Transform<Triple, Quad> transformNamedGraph = new Transform<Triple, Quad>(){

            @Override
            public Quad convert(Triple triple) {
                return new Quad(graphNode, triple);
            }
        };
        return Iter.iter(iter).map(transformNamedGraph);
    }
}

