#!/bin/sh

# Copyright (c) 2012 ken.naruo
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.


# .root load
LANG=C;export LANG
SCRIPT_DIR=`dirname $0`
. ${SCRIPT_DIR}/../.root

PROJECT=$1
JOBNET=$2
JOBNET_HOME=${ROOT}/project/${PROJECT}/${JOBNET}
CONTROLLER_EXE=${JOBNET_HOME}/controller.sh
PROF=${JOBNET_HOME}/jobnet.prof

if [ "${PROJECT}" = "" -o "${JOBNET}" = "" ];then
 echo "usage: enable_jobnet.sh <PROJECT> <JOBNET>"
 exit 1
fi

if [ ! -f ${JOBNET_HOME}/jobnet.prof ];then
 echo "jobnet is not exist"
 exit 1
fi

crontab -l | grep -v ${CONTROLLER_EXE} > ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
  echo "maybe permission is wrong ${JOBNET_HOME}/.crontab_tmp"
  exit 1
fi

#crontab update
crontab ${JOBNET_HOME}/.crontab_tmp

if [ $? != 0 ];then
 echo "disable was failed, please check cron"
fi

echo "-------------------------------------------------------------"
echo "JOBNET:${JOBNET} disabled succesfully"
echo "please check crontab -l "
echo "-------------------------------------------------------------"

rm ${JOBNET_HOME}/.crontab_tmp

exit 0
