﻿#pragma once
#include <Multimedia/Color.h>
#include <chrono>

namespace SDX
{
/** 時間と日付を取得する関数群.*/
///	\include TimerSample.h
class Time
{
private:
	double fps;
	std::chrono::system_clock::time_point reset;
	std::chrono::system_clock::time_point fpsCounter;
	std::chrono::system_clock::time_point watch;

	Time(void)
	{
		this->ResetCount();	
	}

	~Time(void){};

	static Time& Single()
	{
		static Time value;
		return value;
	}

public:
	/** 時間の初期化.*/
	static void ResetCount()
	{
		Single().reset = std::chrono::system_clock::now();
	}
	
	/** リセット後の経過時間のミリ秒で取得(小数点以下).*/
	static double GetNowCount()
	{
		auto diff = std::chrono::system_clock::now() - Single().reset;		
		return (double)std::chrono::duration_cast<std::chrono::microseconds>(diff).count()/ 1000;
	}

	/** 日付を取得.*/
	static tm GetDate()
	{
		time_t timer;
		tm local;
		localtime_s(&local, &timer);
		return local;
	}
		
	/** FPSを取得.*/
	static double GetFPS()
	{
		return Single().fps;
	}
	
	/** FPSの計測開始.*/
	static void ResetFPS()
	{
		Single().fpsCounter = std::chrono::system_clock::now();
	}
	
	/** FPS計測を更新.*/
	static void CheckFPS()
	{
		auto diff = std::chrono::system_clock::now() - Single().fpsCounter;		
		Single().fps = 1000000.0 / (double)std::chrono::duration_cast<std::chrono::microseconds>(diff).count();
		Single().fpsCounter = std::chrono::system_clock::now();
	}
	
	/** 処理時間計測開始.*/
	static void StartWatch()
	{
		Single().watch = std::chrono::system_clock::now();
	}
	
	/** 処理時間計測終了.*/
	///StartWatchからの経過時間をミリ秒単位で描画
	///続けてDrawWatchする事も可能
	static void DrawWatch(int X座標 , int Y座標 , const char* 描画文字列)
	{
		std::string buf = 描画文字列;
		buf += " = %f";

		auto diff = std::chrono::system_clock::now() - Single().watch;
		Drawing::String(X座標, Y座標, Color(255,255,255), buf.c_str(), (double)std::chrono::duration_cast<std::chrono::microseconds>(diff).count() / 1000);
		Single().watch = std::chrono::system_clock::now();
	}
};

}