#pragma once
#include <Object.h>

namespace SDX
{
///	<summary>Object̃ReiNX</summary>
///	\include
class Layer
{
public:
	std::vector<std::shared_ptr<Object>> objects;
	std::vector<std::shared_ptr<Object>> suspend;

	void Add(Object *object , int suspend)
	{
		object->SetTimer(-suspend);

		if( object->GetTimer() >= 0 )
		{
			this->objects.push_back( std::shared_ptr<Object>(object) );
		}else{
			this->suspend.push_back( std::shared_ptr<Object>(object) );
		}
	}

	void Update( )
	{
		auto it = suspend.begin();

		while( it != suspend.end() )
		{
			(*it)->SetTimer( (*it)->GetTimer() + 1 );
			if( (*it)->GetTimer() >= 0 )
			{
				objects.push_back( (*it) );
				it = suspend.erase( it );
				continue;
			}
			++it;
		}

		for (unsigned int i = 0; i < objects.size(); i++)
		{
			objects[i]->Update();
		}
	}

	void Draw()
	{
		for( auto it : objects )
		{
			it->Draw();
		}
	}

	void DrawShadow(double XW , double YW )
	{
		for( auto it : objects )
		{
			it->DrawShadow( XW , YW);
		}
	}

	void ExeRemove(Rect* area)
	{
		for (unsigned int i = 0; i < objects.size(); i++)
		{
			objects[i]->RemoveCheck(area);
		}

		auto it = objects.begin();
		while( it != objects.end() )
		{
			if( (*it)->GetRemoveFlag() )
			{
				it = objects.erase( it );					
			}else{
				++it;
			}
		}
	}

	void Clear()
	{
		objects.clear();
		suspend.clear();
	}

	int GetCount()
	{
		return objects.size();
	}

	Object* GetNearest(Object* object)
	{
		double nearest = -1;
		Object* nearObject = nullptr;

		for( auto it : objects )
		{
			double dist = object->GetDistance( it.get() );
			if( dist < nearest || nearest == -1)
			{
				nearest = dist;
				nearObject = it.get();
			}
		}

		return nearObject;
	}

	void Hit( Layer &layer )
	{
		for( auto itA : objects )
		{
			for( auto itB : layer.objects )
			{
				if( itB->GetRemoveFlag() ) continue;

				if( itA->Hit( itB.get() ) )
				{
					itA->Attack( itB.get() );
					itB->Attack( itA.get() );
				}
			}
		}
	}
			
	void Hit( Object* objcet )
	{

		for( auto it : objects )
		{
			if( it->GetRemoveFlag() ) continue;

			if( it->Hit( objcet ) )
			{
				it->Attack( objcet );
				objcet->Attack( it.get() );
			}
		}

	}
};
}