﻿#pragma once
#include<Multimedia/SDX.h>

namespace SDX
{
/** ウィンドウを表すクラス.*/
///	\include WindowSample.h
class Window
{
	friend class System;

private:
	bool isFullScreen = false;
	int width;
	int height;

	Window(){}

public:

	WindowHandle handle = 0;

	static Window& Single()
	{
		static Window single;
		return single;		
	}

	/** スクリーンモードを設定する.*/
	/// 色々な設定が初期化されるので、注意が必要
	static bool SetFullScreen(bool フルスクリーンフラグ)
	{
		Single().isFullScreen = フルスクリーンフラグ;
	#ifdef DXLIB
		return !DxLib::ChangeWindowMode(!フルスクリーンフラグ);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** ウィンドウタイトルを設定.*/
	static bool SetTitle(const char *タイトル名)
	{
	#ifdef DXLIB
		return !DxLib::SetMainWindowText(タイトル名);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** アイコンIDの設定.*/
	static bool SetIconID(int id)
	{
	#ifdef DXLIB
		return !DxLib::SetWindowIconID(id);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** ウィンドウの拡大縮小可否設定.*/
	static bool SetSizeChangeEnable(bool 拡大縮小可能フラグ)
	{
	#ifdef DXLIB
		return !DxLib::SetWindowSizeChangeEnableFlag(拡大縮小可能フラグ);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** ウィンドウサイズの設定.*/
	static bool SetSize(int 幅,int 高さ )
	{
	#ifdef DXLIB
		return !DxLib::SetWindowSize(幅, 高さ);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** ウィンドウ幅の取得.*/
	static int GetWidth()
	{
		return Single().width;
	}

	/** ウィンドウ高さの取得.*/
	static int GetHeight()
	{
		return Single().height;
	}
};
}