﻿#pragma once
#include<Multimedia/SDX.h>

namespace SDX
{
/** 音声の再生方式.*/
enum class PlayType
{
#ifdef DXLIB
	Normal = DX_PLAYTYPE_NORMAL,/// 再生中、他の処理を止める
	Back = DX_PLAYTYPE_BACK,/// 再生中、他の処理を止めない
	Loop = DX_PLAYTYPE_LOOP,/// 他の処理を止めず、最初から
#elif defined(SDL)
	Normal = 0,/// 再生中、他の処理を止める
	Back = 0,/// 再生中、他の処理を止めない
	Loop = -1,/// 他の処理を止めず、繰り返す
#endif

};

/** 効果音用音声を表すクラス.*/
///	\include SoundSample.h
class Sound
{
private:
	SoundHandle handle;
public:

	Sound(){}

	/** 音声ファイルをメモリに読み込む.*/
	Sound(const char *ファイル名 , double 音量 = 1.0)
	{
		Load(ファイル名);
	}
		
	/** 音声ファイルをメモリに読み込む.*/
	int Load(const char *ファイル名 , double 音量 = 1.0)
	{
	#ifdef DXLIB
		if(this->handle != NULL_HANDLE ) DxLib::DeleteSoundMem(handle);
		DxLib::ChangeVolumeSoundMem(int(音量 * 255), this->handle);
		return this->handle = DxLib::LoadSoundMem(ファイル名);
	#elif defined(SDL)
		handle = Mix_LoadWAV(ファイル名);
		Mix_VolumeChunk(handle, int(音量 * 128));
		return true;
	#endif
	}

	/** 音声ファイルをメモリから開放.*/
	bool Release()
	{
	#ifdef DXLIB
		return !DxLib::DeleteSoundMem(handle);
	#elif defined(SDL)
		Mix_FreeChunk(handle);
		return true;
	#endif
	}

	/** ハンドルを取得.*/
	SoundHandle GetHandle() const
	{
		return this->handle;
	}
		
	/** 音声ファイルを再生.*/
	bool Play(PlayType 再生方法 = PlayType::Back , bool 先頭から再生 = true) const
	{
	#ifdef DXLIB
		return !DxLib::PlaySoundMem(this->handle, (int)再生方法, 先頭から再生);
	#elif defined(SDL)
		//Mix_HaltChannel(-1);
		static int channel = 0;
		Mix_PlayChannel(0, handle, (int)再生方法);
		channel = (++channel) % 2;
		return true;
	#endif
	}
		
	/** 再生中か判定.*/
	bool Check() const
	{
	#ifdef DXLIB
		return !DxLib::CheckSoundMem(this->handle);
	#elif defined(SDL)
		return false;
	#endif
	}
		
	/** 再生を停止.*/
	bool Stop()
	{
	#ifdef DXLIB
		return !DxLib::StopSoundMem(this->handle);
	#elif defined(SDL)
		return false;
	#endif
	}
		
	/** 音声パンを設定.*/
	bool SetPan(int 音声パン)
	{
	#ifdef DXLIB
		return !DxLib::SetPanSoundMem(音声パン, this->handle);
	#elif defined(SDL)
		return false;
	#endif
	}
		
	/** 音量を0～1.0の範囲で設定.*/
	bool SetVolume(double 音量)
	{
	#ifdef DXLIB
		return !DxLib::ChangeVolumeSoundMem(int(音量 * 255), this->handle);
	#elif defined(SDL)
		Mix_VolumeChunk(handle, int(音量 * 128));
		return false;
	#endif
	}
		
	/** 再生周波数を設定.*/
	///単位はHzで範囲は100～100,000
	bool SetFrequency(int 再生周波数)
	{
	#ifdef DXLIB
		return !DxLib::SetFrequencySoundMem(再生周波数, this->handle);
	#elif defined(SDL)
		return false;
	#endif
	}
		
	/** ミリ秒単位でループ位置を設定.*/
	bool SetLoopPos(int ループ位置)
	{
	#ifdef DXLIB
		return !DxLib::SetLoopPosSoundMem(ループ位置, this->handle);
	#elif defined(SDL)
		return false;
	#endif
	}
		
	/** サンプリング周波数でループ位置を設定.*/
	///周期が44.1KHzの場合、44,100を渡すと1秒の位置でループする
	bool SetLoopSamplePos(int ループ周波数)
	{
	#ifdef DXLIB
		return !DxLib::SetLoopSamplePosSoundMem(ループ周波数, this->handle);
	#elif defined(SDL)
		return false;
	#endif
	}
};
}