﻿#pragma once
#include<Multimedia/SDX.h>
#include<Multimedia/Color.h>

namespace SDX
{
/** 補完の方法.*/
enum class DrawMode
{
	Nearest,
	Bilinear
};
	
/** ブレンドモード.*/
enum class BlendMode
{
#ifdef DXLIB
	NoBlend,
	Alpha,
	Add,
	Sub,
	Mula,
	Invsrc
#elif defined(SDL)
	NoBlend = SDL_BLENDMODE_NONE,
	Alpha = SDL_BLENDMODE_BLEND,
	Add = SDL_BLENDMODE_ADD,
	Sub,
	Mula = SDL_BLENDMODE_MOD,
	Invsrc
#endif

};

class Image;
/** 描画先を表すクラス.*/
///	\include ScreenSample.h
class Screen
{
private:
	Screen(){};
	~Screen(){};
	ScreenHandle handle = 0;
public:

	BlendMode nowBlendMode = BlendMode::NoBlend;
	int		  blendParam = 0;
	Color clearColor = Color(0, 0, 0);//消去時の色
	Color rgba = Color(255, 255, 255, 0);//描画輝度と透明度

	static Screen& Single()
	{
		static Screen single;
		return single;
	}
	static ScreenHandle GetHandle()
	{
		return Single().handle;
	}

	static void SetRenderer(ScreenHandle handle)
	{
		Single().handle = handle;
	}

	/** 描画範囲を設定する、設定範囲外には描画されない.*/
	static bool SetArea(int x1,int y1,int x2,int y2)
	{
	#ifdef DXLIB
		return !DxLib::SetDrawArea(x1, y1, x2, y2);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** 作成する画像のビット深度を設定.*/
	///画像を読み込む時のビット深度を下げると、画質が下がる代わりに
	///使用するメモリが減少します
	///この関数は、Image::Load等で画像を読み込む前に呼ぶ必要がある
	static bool SetCreateGraphColorBitDepth(int ビット深度)
	{
	#ifdef DXLIB
		return !DxLib::SetCreateGraphColorBitDepth(ビット深度);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** スクリーン用Imageのチャンネル数を設定.*/
	///チャンネル数は1,2,4のいずれかを指定
	///スクリーン用Imageが指定したチャンネル数で作成されるようになる
	///Image::Make関数を呼ぶ前に、この関数を呼ぶ必要がある
	static bool SetCreateValidGraphChannelNum(int チャンネル数)
	{
	#ifdef DXLIB
		return !DxLib::SetCreateDrawValidGraphChannelNum(チャンネル数);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** 描画先の設定.*/
	///Image::Draw等の描画先を裏画面にする。
	///SetImageを使用してから戻す時に使う
	static bool SetBack()
	{
	#ifdef DXLIB
		return !DxLib::SetDrawScreen(DX_SCREEN_BACK);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** Screen::Clear後の色を設定.*/
	static bool SetBackColor( Color 背景色 )
	{
		Single().clearColor.SetColor(背景色.GetRed(), 背景色.GetGreen(), 背景色.GetBlue());
	#ifdef DXLIB
		return !DxLib::SetBackgroundColor(背景色.GetRed(), 背景色.GetGreen(), 背景色.GetBlue() );
	#elif defined(SDL)
		return true;
	#endif
	}
	
	/** 描画内容を反映.*/
	static bool Flip()
	{
	#ifdef DXLIB
		return !DxLib::ScreenFlip();
	#elif defined(SDL)
		static double nextFrame = SDL_GetTicks();
		const static double wait = 1000.0 / 60;

		while (true)
		{
			if (SDL_GetTicks() >= nextFrame)
			{
				nextFrame = SDL_GetTicks() + wait;
				SDL_Delay(0);
				break;
			}
		}
		SDL_RenderPresent(GetHandle());
		return true;
	#endif
	}
	
	/** 裏画面の内容を、表画面にコピー.*/
	static bool Copy()
	{
	#ifdef DXLIB
		return !DxLib::ScreenCopy();
	#elif defined(SDL)
		SDL_RenderPresent(GetHandle());
		return true;
	#endif
	}
	
	/** 画面を消去する.*/
	static bool Clear()
	{
	#ifdef DXLIB
		return !DxLib::ClearDrawScreen();
	#elif defined(SDL)
		SDL_SetRenderDrawColor
		(
			Screen::GetHandle(),
			Single().clearColor.GetRed(),
			Single().clearColor.GetGreen(),
			Single().clearColor.GetBlue(),
			0
		);
		SDL_RenderClear(GetHandle());
		return true;
	#endif
	}
	
	/** 拡大描画の補完方法を設定.*/
	static bool SetMode(DrawMode 補完モード)
	{
	#ifdef DXLIB
		return !DxLib::SetDrawMode((int)補完モード);
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** ブレンド描画のモードを設定.*/
	static bool SetBlendMode(BlendMode ブレンドモード,int 設定値)
	{
		Single().nowBlendMode = ブレンドモード;
		Single().blendParam = 設定値;
	#ifdef DXLIB
		return !DxLib::SetDrawBlendMode((int)ブレンドモード, 設定値);
	#elif defined(SDL)
		return true;
	#endif
	}
	
	/** 描画対象になっている画面の一部をBMP形式で保存.*/
	static bool SaveBmp(int x1, int y1 , int x2 , int y2 , const char *ファイル名 )
	{
	#ifdef DXLIB
		return !DxLib::SaveDrawScreen(x1, y1, x2, y2, ファイル名);
	#elif defined(SDL)
		return false;
	#endif
	}

	/** 描画輝度を設定.*/
	static bool SetBright( Color 輝度 )
	{
	#ifdef DXLIB
		return !DxLib::SetDrawBright(輝度.GetRed(), 輝度.GetGreen(), 輝度.GetBlue());
	#elif defined(SDL)
		Single().rgba.SetColor(輝度.GetRed(), 輝度.GetGreen(), 輝度.GetBlue());
		return true;
	#endif
	}

	/** 透過色を設定.*/
	static bool SetTransColor(Color 輝度)
	{
	#ifdef DXLIB
		return !DxLib::SetTransColor(輝度.GetRed(), 輝度.GetGreen(), 輝度.GetBlue());
	#elif defined(SDL)
		return false;
	#endif
	}
	
	/** Zバッファ使用フラグを設定.*/
	static void SetZUse(bool 使用フラグ )
	{
	#ifdef DXLIB
		DxLib::SetUseZBufferFlag(使用フラグ);
	#elif defined(SDL)
		return;
	#endif
	}
		
	/** Zバッファ描画フラグを設定.*/
	static void SetZWrite(bool 使用フラグ )
	{
	#ifdef DXLIB
		DxLib::SetWriteZBufferFlag(使用フラグ);
	#elif defined(SDL)
		return;
	#endif
	}

	/** Z描画深度0.0～1.0の範囲で設定.*/
	static void SetZDepth(double Z深度)
	{
	#ifdef DXLIB
		DxLib::SetDrawZ((float)Z深度);
	#elif defined(SDL)
		return;
	#endif
	}
};
}